/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.LiquibaseHubObjectNotFoundException;
import liquibase.hub.LiquibaseHubRedirectException;
import liquibase.hub.LiquibaseHubSecurityException;
import liquibase.hub.model.ListResponse;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

class HttpClient {
    private Yaml yaml;

    protected HttpClient() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        this.yaml = new Yaml(new Constructor(), new HubRepresenter(), dumperOptions);
        this.yaml.setBeanAccess(BeanAccess.FIELD);
    }

    protected <T> T doGet(String url, Class<T> returnType) throws LiquibaseHubException {
        return this.doGet(url, new HashMap<String, String>(), returnType);
    }

    protected <T> ListResponse doGet(String url, Map<String, String> parameters, Class<ListResponse> listResponseClass, Class<T> contentType) throws LiquibaseHubException {
        try {
            if (parameters != null && parameters.size() > 0) {
                url = url + "?" + this.toQueryString(parameters);
            }
            return this.doRequest("GET", url, null, listResponseClass, contentType);
        }
        catch (LiquibaseHubRedirectException lhre) {
            return this.doRequest("GET", url, null, listResponseClass, contentType);
        }
    }

    protected <T> T doGet(String url, Map<String, String> parameters, Class<T> returnType) throws LiquibaseHubException {
        if (parameters != null && parameters.size() > 0) {
            url = url + "?" + this.toQueryString(parameters);
        }
        return this.doRequest("GET", url, null, returnType);
    }

    protected <T> T doPost(String url, Object requestBodyObject, Class<T> returnType) throws LiquibaseHubException {
        return this.doRequest("POST", url, requestBodyObject, returnType);
    }

    protected <T> T doPut(String url, Object requestBodyObject, Class<T> returnType) throws LiquibaseHubException {
        return this.doRequest("PUT", url, requestBodyObject, returnType);
    }

    protected <T> T doDelete(String url, Class<T> returnType) throws LiquibaseHubException {
        return this.doRequest("DELETE", url, null, returnType);
    }

    private URLConnection openConnection(String url) throws LiquibaseHubException {
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        String apiKey = hubConfiguration.getLiquibaseHubApiKey();
        try {
            URLConnection connection = new URL(this.getHubUrl() + url).openConnection();
            connection.setRequestProperty("User-Agent", "Liquibase " + LiquibaseUtil.getBuildVersion());
            connection.setRequestProperty("Authorization", "Bearer " + apiKey);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            return connection;
        }
        catch (IOException e2) {
            throw new LiquibaseHubException(e2);
        }
    }

    private String toQueryString(Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        ArrayList<String> paramArray = new ArrayList<String>();
        try {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                paramArray.add(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return StringUtil.join(paramArray, "&");
    }

    private <T> T doRequest(String method, String url, Object requestBodyObject, Class<T> returnType) throws LiquibaseHubException {
        try {
            return this.doRequest(method, url, requestBodyObject, returnType, null);
        }
        catch (LiquibaseHubRedirectException lhre) {
            return this.doRequest(method, url, requestBodyObject, returnType, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doRequest(String method, String url, Object requestBodyObject, Class<T> returnType, Class contentReturnType) throws LiquibaseHubException {
        try {
            Throwable throwable;
            Object output;
            HttpURLConnection connection = (HttpURLConnection)this.openConnection(url);
            if (requestBodyObject != null) {
                connection.setDoOutput(true);
            }
            connection.setRequestMethod(method);
            String requestBodyDescription = "";
            if (requestBodyObject != null) {
                String requestBody = this.yaml.dumpAs(requestBodyObject, Tag.MAP, DumperOptions.FlowStyle.FLOW);
                requestBody = requestBody.replaceAll("(?m)^(\\s*)!![a-zA-Z0-9.]+", "$1").replaceAll("!!int \"(\\d+)\"", "$1").replaceAll("!!java.util.UUID ", "").replaceAll("!!null \"null\"", "null").replaceAll("!!liquibase.hub.model.hubChange ", "").replaceAll("!!timestamp '(.+?)'", "\"$1\"");
                output = connection.getOutputStream();
                throwable = null;
                try {
                    ((OutputStream)output).write(requestBody.getBytes(StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output != null) {
                        if (throwable != null) {
                            try {
                                ((OutputStream)output).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((OutputStream)output).close();
                        }
                    }
                }
                requestBodyDescription = " with a " + requestBody.length() + " char " + requestBodyObject.getClass().getName() + " request body";
            }
            Scope.getCurrentScope().getLog(this.getClass()).fine(method.toUpperCase() + " " + url + requestBodyDescription);
            try {
                InputStream response = connection.getInputStream();
                output = null;
                try {
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200 && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
                        String newHubUrl = connection.getHeaderField("Location");
                        newHubUrl = newHubUrl.replaceAll(url, "");
                        Scope.getCurrentScope().getLog(this.getClass()).info("Redirecting to URL: " + newHubUrl);
                        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
                        hubConfiguration.setLiquibaseHubUrl(newHubUrl);
                        throw new LiquibaseHubRedirectException();
                    }
                    String contentType = connection.getContentType();
                    if (!contentType.equals("application/json")) {
                        throw new LiquibaseHubException("\nUnexpected content type '" + contentType + "' returned from Hub.  Response code is " + responseCode);
                    }
                    T hubConfiguration = this.yaml.loadAs(response, returnType);
                    return hubConfiguration;
                }
                catch (Throwable throwable4) {
                    output = throwable4;
                    throw throwable4;
                }
                finally {
                    if (response != null) {
                        if (output != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)output).addSuppressed(throwable5);
                            }
                        } else {
                            response.close();
                        }
                    }
                }
            }
            catch (IOException e2) {
                if (connection.getResponseCode() == 401) {
                    throw new LiquibaseHubSecurityException("Authentication failure for " + connection.getRequestMethod() + " " + connection.getURL().toExternalForm());
                }
                try {
                    throwable = null;
                    try (InputStream error = connection.getErrorStream();){
                        if (error == null) throw new LiquibaseHubException(e2);
                        Object loadedObject = this.yaml.load(error);
                        if (loadedObject instanceof Map) {
                            Map errorDetails = (Map)this.yaml.load(error);
                            LiquibaseHubException returnException = new LiquibaseHubException((String)errorDetails.get("message"), e2);
                            if (connection.getResponseCode() == 404) {
                                returnException = new LiquibaseHubObjectNotFoundException(returnException.getMessage(), returnException.getCause());
                            }
                            returnException.setTimestamp((String)errorDetails.get("timestamp"));
                            returnException.setDetails((String)errorDetails.get("details"));
                            throw returnException;
                        }
                        String errorMessage = "Unable to parse '" + loadedObject.toString() + "': " + e2.getMessage();
                        throw new LiquibaseHubException(errorMessage, e2.getCause());
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (IOException ioException) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Cannot read request error stream", e2);
                }
                throw new LiquibaseHubException(e2);
            }
        }
        catch (IOException e3) {
            throw new LiquibaseHubException(e3);
        }
    }

    public String getHubUrl() {
        HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        return hubConfiguration.getLiquibaseHubUrl();
    }

    private static class HubRepresenter
    extends Representer {
        HubRepresenter() {
            this.getPropertyUtils().setSkipMissingProperties(true);
        }

        @Override
        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }
    }
}

