/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dsql.model.ClusterArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiRegionProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiRegionProperties> {
    private static final SdkField<String> WITNESS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("witnessRegion").getter(MultiRegionProperties.getter(MultiRegionProperties::witnessRegion)).setter(MultiRegionProperties.setter(Builder::witnessRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("witnessRegion").build()}).build();
    private static final SdkField<List<String>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusters").getter(MultiRegionProperties.getter(MultiRegionProperties::clusters)).setter(MultiRegionProperties.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WITNESS_REGION_FIELD, CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiRegionProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String witnessRegion;
    private final List<String> clusters;

    private MultiRegionProperties(BuilderImpl builder) {
        this.witnessRegion = builder.witnessRegion;
        this.clusters = builder.clusters;
    }

    public final String witnessRegion() {
        return this.witnessRegion;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<String> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.witnessRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionProperties)) {
            return false;
        }
        MultiRegionProperties other = (MultiRegionProperties)obj;
        return Objects.equals(this.witnessRegion(), other.witnessRegion()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters());
    }

    public final String toString() {
        return ToString.builder((String)"MultiRegionProperties").add("WitnessRegion", (Object)this.witnessRegion()).add("Clusters", this.hasClusters() ? this.clusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "witnessRegion": {
                return Optional.ofNullable(clazz.cast(this.witnessRegion()));
            }
            case "clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("witnessRegion", WITNESS_REGION_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionProperties, T> g) {
        return obj -> g.apply((MultiRegionProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String witnessRegion;
        private List<String> clusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionProperties model) {
            this.witnessRegion(model.witnessRegion);
            this.clusters(model.clusters);
        }

        public final String getWitnessRegion() {
            return this.witnessRegion;
        }

        public final void setWitnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
        }

        @Override
        public final Builder witnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
            return this;
        }

        public final Collection<String> getClusters() {
            if (this.clusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusters;
        }

        public final void setClusters(Collection<String> clusters) {
            this.clusters = ClusterArnListCopier.copy(clusters);
        }

        @Override
        public final Builder clusters(Collection<String> clusters) {
            this.clusters = ClusterArnListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(String ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public MultiRegionProperties build() {
            return new MultiRegionProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiRegionProperties> {
        public Builder witnessRegion(String var1);

        public Builder clusters(Collection<String> var1);

        public Builder clusters(String ... var1);
    }
}

