/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.dsql.DefaultDsqlAsyncClientBuilder;
import software.amazon.awssdk.services.dsql.DsqlAsyncClientBuilder;
import software.amazon.awssdk.services.dsql.DsqlServiceClientConfiguration;
import software.amazon.awssdk.services.dsql.DsqlUtilities;
import software.amazon.awssdk.services.dsql.model.CreateClusterRequest;
import software.amazon.awssdk.services.dsql.model.CreateClusterResponse;
import software.amazon.awssdk.services.dsql.model.DeleteClusterRequest;
import software.amazon.awssdk.services.dsql.model.DeleteClusterResponse;
import software.amazon.awssdk.services.dsql.model.GetClusterRequest;
import software.amazon.awssdk.services.dsql.model.GetClusterResponse;
import software.amazon.awssdk.services.dsql.model.GetVpcEndpointServiceNameRequest;
import software.amazon.awssdk.services.dsql.model.GetVpcEndpointServiceNameResponse;
import software.amazon.awssdk.services.dsql.model.ListClustersRequest;
import software.amazon.awssdk.services.dsql.model.ListClustersResponse;
import software.amazon.awssdk.services.dsql.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.dsql.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.dsql.model.TagResourceRequest;
import software.amazon.awssdk.services.dsql.model.TagResourceResponse;
import software.amazon.awssdk.services.dsql.model.UntagResourceRequest;
import software.amazon.awssdk.services.dsql.model.UntagResourceResponse;
import software.amazon.awssdk.services.dsql.model.UpdateClusterRequest;
import software.amazon.awssdk.services.dsql.model.UpdateClusterResponse;
import software.amazon.awssdk.services.dsql.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.dsql.waiters.DsqlAsyncWaiter;

@SdkPublicApi
@ThreadSafe
public interface DsqlAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "dsql";
    public static final String SERVICE_METADATA_ID = "dsql";

    default public DsqlUtilities utilities() {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return this.createCluster((CreateClusterRequest)((Object)((CreateClusterRequest.Builder)CreateClusterRequest.builder().applyMutation(createClusterRequest)).build()));
    }

    default public CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return this.deleteCluster((DeleteClusterRequest)((Object)((DeleteClusterRequest.Builder)DeleteClusterRequest.builder().applyMutation(deleteClusterRequest)).build()));
    }

    default public CompletableFuture<GetClusterResponse> getCluster(GetClusterRequest getClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetClusterResponse> getCluster(Consumer<GetClusterRequest.Builder> getClusterRequest) {
        return this.getCluster((GetClusterRequest)((Object)((GetClusterRequest.Builder)GetClusterRequest.builder().applyMutation(getClusterRequest)).build()));
    }

    default public CompletableFuture<GetVpcEndpointServiceNameResponse> getVpcEndpointServiceName(GetVpcEndpointServiceNameRequest getVpcEndpointServiceNameRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetVpcEndpointServiceNameResponse> getVpcEndpointServiceName(Consumer<GetVpcEndpointServiceNameRequest.Builder> getVpcEndpointServiceNameRequest) {
        return this.getVpcEndpointServiceName((GetVpcEndpointServiceNameRequest)((Object)((GetVpcEndpointServiceNameRequest.Builder)GetVpcEndpointServiceNameRequest.builder().applyMutation(getVpcEndpointServiceNameRequest)).build()));
    }

    default public CompletableFuture<ListClustersResponse> listClusters(ListClustersRequest listClustersRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListClustersResponse> listClusters(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return this.listClusters((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public ListClustersPublisher listClustersPaginator(ListClustersRequest listClustersRequest) {
        return new ListClustersPublisher(this, listClustersRequest);
    }

    default public ListClustersPublisher listClustersPaginator(Consumer<ListClustersRequest.Builder> listClustersRequest) {
        return this.listClustersPaginator((ListClustersRequest)((Object)((ListClustersRequest.Builder)ListClustersRequest.builder().applyMutation(listClustersRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public CompletableFuture<UpdateClusterResponse> updateCluster(UpdateClusterRequest updateClusterRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UpdateClusterResponse> updateCluster(Consumer<UpdateClusterRequest.Builder> updateClusterRequest) {
        return this.updateCluster((UpdateClusterRequest)((Object)((UpdateClusterRequest.Builder)UpdateClusterRequest.builder().applyMutation(updateClusterRequest)).build()));
    }

    default public DsqlAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    default public DsqlServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static DsqlAsyncClient create() {
        return (DsqlAsyncClient)DsqlAsyncClient.builder().build();
    }

    public static DsqlAsyncClientBuilder builder() {
        return new DefaultDsqlAsyncClientBuilder();
    }
}

