/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp.alloydb;

import com.dbeaver.cloud.gcp.GCPCloudAbstractInstance;
import com.dbeaver.cloud.gcp.GCPCloudService;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.google.api.services.alloydb.v1.model.Instance;
import com.google.api.services.alloydb.v1.model.Node;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.utils.CommonUtils;

public class GCPAlloyDBInstance
extends GCPCloudAbstractInstance {
    private final Instance instance;
    private final String state;
    private final String instanceType;
    private final String createTime;
    private final String updateTime;
    private final String availabilityType;
    private String zoneId;

    public GCPAlloyDBInstance(@NotNull GCPCloudSession session, @NotNull GCPProject project, Instance instance) {
        super(session, project);
        this.instance = instance;
        this.state = instance.getState();
        this.instanceType = instance.getInstanceType();
        this.createTime = instance.getCreateTime();
        this.updateTime = instance.getUpdateTime();
        this.availabilityType = instance.getAvailabilityType();
        Node writableNode = instance.getWritableNode();
        if (writableNode != null) {
            this.zoneId = writableNode.getZoneId();
        }
    }

    @Override
    protected void setDataSourceConfiguration(DataSourceDescriptor dataSource, DBPConnectionConfiguration configuration) throws DBException {
        configuration.setHostName(this.instance.getIpAddress());
        String userName = this.getInstanceUserName();
        if (userName == null) {
            userName = this.getCloudService().getInstanceDriver().getDefaultUser();
        }
        configuration.setUserName(userName);
        configuration.setDatabaseName(this.getCloudService().getInstanceDriver().getDefaultDatabase());
        configuration.setServerName(this.instance.getName());
        configuration.setHostPort("5432");
        configuration.setAuthModelId("gcp_cloud_iam_alloydb");
    }

    @Override
    protected GCPCloudService getCloudService() {
        return GCPCloudService.ALLOYDB;
    }

    @Override
    protected String getInstanceARN() {
        return this.instance.getName();
    }

    @Override
    protected String getExternalLink() {
        String location = null;
        String instanceName = this.instance.getName();
        if (CommonUtils.isNotEmpty((String)this.zoneId)) {
            location = this.zoneId;
        } else if (CommonUtils.isNotEmpty((String)instanceName)) {
            location = this.parsePathToFindInfo(instanceName, "/locations/");
        }
        String clustersInfo = this.parsePathToFindInfo(instanceName, "/clusters/");
        if (CommonUtils.isNotEmpty((String)location) && CommonUtils.isNotEmpty((String)clustersInfo)) {
            return "https://console.cloud.google.com/alloydb/locations/" + location + " /clusters/" + clustersInfo + "/overview?project=" + this.getFolder().getFolderId();
        }
        return "https://console.cloud.google.com/alloydb/instances/";
    }

    private String parsePathToFindInfo(@NotNull String path, @NotNull String pathPart) {
        String afterLocations;
        if (path.contains(pathPart) && CommonUtils.isNotEmpty((String)(afterLocations = path.substring(path.lastIndexOf(pathPart) + pathPart.length())))) {
            return afterLocations.substring(0, afterLocations.indexOf("/"));
        }
        return null;
    }

    @Nullable
    public String getInstanceEndpoint() {
        return null;
    }

    @NotNull
    public String getNodeId() {
        return this.instance.getName();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.getName();
    }

    @Override
    @NotNull
    public GCPCloudZone getZone() {
        if (CommonUtils.isNotEmpty((String)this.zoneId)) {
            return GCPCloudZone.valueOf(this.zoneId);
        }
        String zone = this.instance.getGceZone();
        if (CommonUtils.isNotEmpty((String)zone)) {
            return GCPCloudZone.valueOf(zone);
        }
        return super.getZone();
    }

    @Property(viewable=true, order=10)
    public String getState() {
        return this.state;
    }

    @Property(viewable=true, order=11)
    public String getInstanceType() {
        return this.instanceType;
    }

    @Property(viewable=true, order=12)
    public String getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=13)
    public String getUpdateTime() {
        return this.updateTime;
    }

    @Property(viewable=true, order=14)
    public String getAvailabilityType() {
        return this.availabilityType;
    }
}

