/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.gcp;

import com.dbeaver.cloud.gcp.GCPCloudConfiguration;
import com.dbeaver.cloud.gcp.GCPCloudDataSourceOrigin;
import com.dbeaver.cloud.gcp.GCPCloudDataSourceStorage;
import com.dbeaver.cloud.gcp.GCPCloudExplorer;
import com.dbeaver.cloud.gcp.GCPCloudProvider;
import com.dbeaver.cloud.gcp.GCPCloudSession;
import com.dbeaver.cloud.gcp.GCPCloudUtils;
import com.dbeaver.cloud.gcp.GCPCloudZone;
import com.dbeaver.cloud.gcp.GCPProject;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.net.auth.gcp.AuthModelGCPCredentials;
import com.google.api.client.http.HttpResponse;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfo;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class GCPCloud
extends AbstractCloud<GCPCloudProvider, GCPCloudConfiguration, GCPCloudZone, GCPCloudSession>
implements CPCloudSessionManager<GCPCloudSession, GCPCloudZone> {
    private static final Log log = Log.getLog(GCPCloud.class);
    private final GCPCloudDataSourceStorage dataSourceStorage = new GCPCloudDataSourceStorage(this);

    GCPCloud(GCPCloudProvider provider, GCPCloudConfiguration configuration) {
        super((CPCloudProvider)provider, (AbstractCloudConfiguration)configuration);
    }

    @NotNull
    public GCPCloudZone[] getAllZones() {
        return new GCPCloudZone[0];
    }

    @NotNull
    public GCPCloudExplorer createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull GCPCloudSession session) {
        return new GCPCloudExplorer(this, session);
    }

    public GCPCloudSession getActiveSession() {
        try {
            return (GCPCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBRProgressMonitor)new VoidProgressMonitor(), (SMAuthSpace)this, false);
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        SMSessionProviderService sessionProviderService = (SMSessionProviderService)DBWorkbench.getService(SMSessionProviderService.class);
        if (sessionProviderService == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to GCP Cloud", 1);
        GCPCloudSession session = (GCPCloudSession)DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession(monitor, (SMAuthSpace)this, true);
        if (session == null) {
            throw new DBException("GCP session not found");
        }
        try {
            AuthModelGCPCredentials credentials = session.getCredentials();
            credentials.resolveCredentials(monitor);
            CloudResourceManager crm = (CloudResourceManager)GCPCloudUtils.buildClient(new CloudResourceManager.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)));
            try {
                CloudResourceManager.Projects.List projectList = crm.projects().list();
                HttpResponse httpResponse = projectList.executeUnparsed();
                Object server = httpResponse.getHeaders().get((Object)"Server");
                String userIdentity = credentials.getUserIdentity(monitor);
                StringBuilder message = new StringBuilder();
                message.append(httpResponse.getStatusMessage()).append(" (Server: ").append(server).append(")");
                if (userIdentity != null) {
                    message.append("\nAccount: ").append(userIdentity);
                }
                String string = message.toString();
                return string;
            }
            catch (IOException e) {
                throw new DBException("Error reading project list", (Throwable)e);
            }
            finally {
                monitor.done();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            session.close();
        }
    }

    public String refreshSession(DBRProgressMonitor monitor) throws DBException {
        GCPCloudSession session = this.getActiveSession();
        if (session == null) {
            return "No active session, nothing to refresh";
        }
        if (session.getCredentials().refreshSession(monitor)) {
            return "SSO re-authenticated";
        }
        return "Nothing to refresh";
    }

    public void closeSession(DBRProgressMonitor monitor) throws DBException {
        GCPCloudSession session = this.getActiveSession();
        if (session != null) {
            session.getCredentials().closeSession(monitor);
            session.closeSession();
        }
    }

    Userinfo readGetCallerIdentity(DBRProgressMonitor monitor, GCPCloudSession session) throws DBException {
        monitor.subTask("Ping STS service");
        AuthModelGCPCredentials credentials = session.getCredentials();
        Oauth2 oauth2 = new Oauth2.Builder(credentials.getTransport(), credentials.getJsonFactory(), credentials.getRequestInitializer(monitor)).build();
        try {
            return (Userinfo)oauth2.userinfo().get().execute();
        }
        catch (IOException e) {
            Userinfo userinfo = new Userinfo();
            userinfo.setId(e.getMessage());
            return userinfo;
        }
    }

    GCPCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }

    DBPDataSourceOrigin createOrigin(GCPCloud cloud, GCPCloudZone zone, GCPProject project, String resourceId, String nodeId) {
        CloudProviderDescriptor cloudProvider = GCPCloudUtils.getGcpCloudProvider();
        LinkedHashMap<String, Object> dsConfiguration = new LinkedHashMap<String, Object>();
        dsConfiguration.put("cloud-provider", cloudProvider.getId());
        dsConfiguration.put("cloud-id", cloud.getCloudId());
        if (zone != null) {
            dsConfiguration.put("cloud-zone-id", zone.getZoneId());
        }
        dsConfiguration.put("gcp-project", project.getProjectId());
        dsConfiguration.put("gcp-resource", resourceId);
        dsConfiguration.put("gcp-node-id", nodeId);
        return new GCPCloudDataSourceOrigin(cloudProvider, dsConfiguration, null);
    }
}

