/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.vqb.model;

import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDContext;
import org.jkiss.dbeaver.model.erd.ERDElement;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ERDJoin
extends ERDAssociation {
    private static final Log log = Log.getLog(ERDAssociation.class);
    private final List<Expression> expressions = new ArrayList<Expression>();

    public ERDJoin(ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        super((ERDElement)sourceEntity, (ERDElement)targetEntity, reflect);
    }

    public List<Expression> makeExpressionFromConditions() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        List source = this.getSourceAttributes();
        List target = this.getTargetAttributes();
        int i = 0;
        while (i < source.size()) {
            Expression expr = this.makeEquals((ERDEntityAttribute)source.get(i), (ERDEntityAttribute)target.get(i));
            result.add(expr);
            ++i;
        }
        result.addAll(this.expressions);
        if (result.isEmpty()) {
            return List.of();
        }
        return List.of(VQBUtils.makeAndExpression(result));
    }

    public ERDEntity getSourceEntity() {
        return (ERDEntity)super.getSourceEntity();
    }

    public ERDEntity getTargetEntity() {
        return (ERDEntity)super.getTargetEntity();
    }

    public void addCondition(Expression expression) {
        this.expressions.add(expression);
    }

    public void removeCondition(Expression expression) {
        if (!this.expressions.remove(expression)) {
            this.resetConnections(expression);
        }
    }

    public void updateCondition(Expression curExpression, Expression newExpression) {
        if (newExpression == null) {
            return;
        }
        int i = 0;
        while (i < this.expressions.size()) {
            if (this.expressions.get(i) == curExpression) {
                this.expressions.set(i, newExpression);
                return;
            }
            ++i;
        }
    }

    private Expression makeEquals(ERDEntityAttribute src, ERDEntityAttribute target) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression(this.makeColumn(this.getSourceEntity(), src));
        equalsTo.setRightExpression(this.makeColumn(this.getTargetEntity(), target));
        return equalsTo;
    }

    private Expression makeColumn(ERDEntity srcEntity, ERDEntityAttribute src) {
        return new Column(VQBUtils.getTableFromEntity(srcEntity), DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)src.getObject())));
    }

    public Join createStatementJoin() {
        Join join = new Join();
        join.setInner(true);
        join.setRightItem((FromItem)this.getTargetEntity().getUserData());
        join.setOnExpressions(this.makeExpressionFromConditions());
        this.setUserData(join);
        return join;
    }

    public void updateStatementJoin(Join join) {
        join.setOnExpressions(this.makeExpressionFromConditions());
        this.setUserData(join);
    }

    public void setJoin(Join join) {
        this.setUserData(join);
    }

    public Map<String, Object> toMap(@NotNull ERDContext context, boolean fullInfo) {
        Map map = super.toMap(context, fullInfo);
        Join join = (Join)this.getUserData();
        if (join == null) {
            join = this.createStatementJoin();
        }
        map.put("joinType", VQBJoinType.getByJoin(join));
        return map;
    }
}

