/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.vqb.builder;

import com.dbeaver.model.sql.vqb.model.ERDJoin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDDiagram;
import org.jkiss.dbeaver.model.erd.ERDEntity;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.utils.CommonUtils;

public class VQBQueryGenerator {
    private static final Log log = Log.getLog(VQBQueryGenerator.class);
    private DBPDataSource dataSource;
    private SQLIdentifierDetector identifierDetector;

    public VQBQueryGenerator(DBPDataSource dataSource) {
        this.dataSource = dataSource;
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        this.identifierDetector = new SQLIdentifierDetector(dialect);
    }

    public SQLQuery generateQueryFromDiagram(DBRProgressMonitor monitor, ERDDiagram diagram) {
        List entities = diagram.getEntities();
        StringBuilder sqlText = new StringBuilder();
        sqlText.append("SELECT");
        ArrayList<SelectItemInfo> allCheckedAttrs = new ArrayList<SelectItemInfo>();
        for (ERDEntity entity : entities) {
            List checkedAttributes = entity.getCheckedAttributes();
            if (checkedAttributes.size() == entity.getAttributes().size()) {
                allCheckedAttrs.add(new SelectItemInfo(null, entity));
                continue;
            }
            Iterator iterator = checkedAttributes.iterator();
            while (iterator.hasNext()) {
                ERDEntityAttribute attr = (ERDEntityAttribute)iterator.next();
                allCheckedAttrs.add(new SelectItemInfo(attr, entity));
            }
        }
        if (allCheckedAttrs.size() == 0) {
            sqlText.append(" *");
        } else {
            allCheckedAttrs.sort((o1, o2) -> {
                if (o1.attribute == o2.attribute) {
                    return 0;
                }
                if (o1.attribute == null) {
                    return -1;
                }
                if (o2.attribute == null) {
                    return 1;
                }
                return o1.attribute.getOrder() - o2.attribute.getOrder();
            });
            int i = 0;
            while (i < allCheckedAttrs.size()) {
                SelectItemInfo item = (SelectItemInfo)allCheckedAttrs.get(i);
                if (i > 0) {
                    sqlText.append(",");
                }
                sqlText.append("\n\t");
                if (!CommonUtils.isEmpty((String)item.entity.getAlias())) {
                    sqlText.append(item.entity.getAlias());
                } else {
                    sqlText.append(DBUtils.getObjectFullName((DBPNamedObject)item.entity, (DBPEvaluationContext)DBPEvaluationContext.DML));
                }
                sqlText.append(".");
                if (item.attribute == null) {
                    sqlText.append("*");
                } else {
                    sqlText.append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)item.attribute.getName()));
                }
                ++i;
            }
        }
        sqlText.append("\n");
        ArrayList<ERDEntity> rootEntities = new ArrayList<ERDEntity>();
        HashMap<ERDEntity, List> joinedEntities = new HashMap<ERDEntity, List>();
        for (ERDEntity entity : entities) {
            boolean hasJoins = false;
            for (ERDAssociation assoc : entity.getAssociations()) {
                if (!(assoc instanceof ERDJoin)) continue;
                hasJoins = true;
                List joinList = joinedEntities.computeIfAbsent((ERDEntity)assoc.getTargetEntity(), k -> new ArrayList());
                joinList.add((ERDEntity)assoc.getSourceEntity());
            }
            if (hasJoins) continue;
            rootEntities.add(entity);
        }
        sqlText.append("FROM ");
        int i = 0;
        while (i < rootEntities.size()) {
            if (i > 0) {
                sqlText.append(",");
            }
            sqlText.append("\n\t");
            ERDEntity entity = (ERDEntity)rootEntities.get(i);
            sqlText.append(DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DML));
            if (!CommonUtils.isEmpty((String)entity.getAlias())) {
                sqlText.append(" ").append(entity.getAlias());
            }
            ++i;
        }
        sqlText.append("\n");
        for (ERDEntity rootEntity : rootEntities) {
            List joinedList = (List)joinedEntities.get(rootEntity);
            if (joinedList == null) continue;
            for (ERDEntity joinedEntity : joinedList) {
                ERDJoin join = null;
                for (ERDAssociation assoc : joinedEntity.getAssociations()) {
                    if (!(assoc instanceof ERDJoin) || assoc.getTargetEntity() != rootEntity) continue;
                    join = (ERDJoin)assoc;
                    break;
                }
                if (join == null) {
                    log.debug((Object)("Can't find join for " + String.valueOf(joinedEntity) + " with " + String.valueOf(rootEntity)));
                    continue;
                }
                this.generateJoin(sqlText, join);
            }
        }
        SQLQuery query = new SQLQuery(this.dataSource, sqlText.toString());
        return query;
    }

    private void generateJoin(StringBuilder sqlText, ERDJoin join) {
        ERDEntity leftEntity = join.getSourceEntity();
        ERDEntity rightEntity = join.getTargetEntity();
        sqlText.append("JOIN ").append(DBUtils.getObjectFullName((DBPNamedObject)leftEntity, (DBPEvaluationContext)DBPEvaluationContext.DML));
        String leftPrefix = "";
        String rightPrefix = "";
        if (!CommonUtils.isEmpty((String)leftEntity.getAlias())) {
            sqlText.append(" ").append(leftEntity.getAlias());
            leftPrefix = leftEntity.getAlias();
        } else {
            leftPrefix = DBUtils.getObjectFullName((DBPNamedObject)leftEntity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        rightPrefix = !CommonUtils.isEmpty((String)rightEntity.getAlias()) ? rightEntity.getAlias() : DBUtils.getObjectFullName((DBPNamedObject)rightEntity, (DBPEvaluationContext)DBPEvaluationContext.DML);
        sqlText.append("\n\tON  ");
        List srcAttrs = join.getSourceAttributes();
        List targetAttrs = join.getTargetAttributes();
        int i = 0;
        while (i < srcAttrs.size()) {
            ERDEntityAttribute srcAttr = (ERDEntityAttribute)srcAttrs.get(i);
            ERDEntityAttribute targetAttr = (ERDEntityAttribute)targetAttrs.get(i);
            if (i > 0) {
                sqlText.append(" AND ");
            }
            sqlText.append(leftPrefix).append(".").append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)srcAttr.getName()));
            sqlText.append(" = ");
            sqlText.append(rightPrefix).append(".").append(DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)targetAttr.getName()));
            ++i;
        }
        sqlText.append("\n");
    }

    private static class SelectItemInfo {
        ERDEntityAttribute attribute;
        ERDEntity entity;

        public SelectItemInfo(ERDEntityAttribute attribute, ERDEntity entity) {
            this.attribute = attribute;
            this.entity = entity;
        }
    }
}

