/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.msi.fluent.models.SystemAssignedIdentityProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.UUID;

public final class SystemAssignedIdentityInner
extends ProxyResource {
    @JsonProperty(value="location", required=true)
    private String location;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="properties", access=JsonProperty.Access.WRITE_ONLY)
    private SystemAssignedIdentityProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    private static final ClientLogger LOGGER = new ClientLogger(SystemAssignedIdentityInner.class);

    public String location() {
        return this.location;
    }

    public SystemAssignedIdentityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemAssignedIdentityInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private SystemAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public String clientSecretUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().clientSecretUrl();
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property location in model SystemAssignedIdentityInner"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

