/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.exec.KSQLExecutionContext;
import com.dbeaver.db.kafka.exec.KSQLSelectStatement;
import com.dbeaver.db.kafka.exec.KSQLSession;
import com.dbeaver.db.kafka.model.KSQLDataSource;
import com.dbeaver.db.kafka.model.KSQLField;
import com.dbeaver.db.kafka.model.KSQLTopic;
import io.confluent.ksql.api.client.FieldInfo;
import io.confluent.ksql.api.client.SourceDescription;
import io.confluent.ksql.api.client.StreamInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;

public class KSQLStream
implements DBSEntity,
DBSDataContainer,
DBSDataManipulator,
DBPRefreshableObject,
DBPScriptObject {
    private static final Log log = Log.getLog(KSQLStream.class);
    private final KSQLDataSource dataSource;
    private final StreamInfo stream;
    private final KSQLExecutionContext executionContext;
    private final AttributeCache attributeCache = new AttributeCache();
    private KSQLTopic topic = null;
    private String ddl;

    public KSQLStream(@Nullable KSQLDataSource ksqlDataSource, @NotNull StreamInfo streamInfo, @NotNull KSQLExecutionContext executionContext, @NotNull DBRProgressMonitor monitor) {
        this.dataSource = ksqlDataSource;
        this.stream = streamInfo;
        this.executionContext = executionContext;
        if (!CommonUtils.isEmpty((String)this.stream.getTopic()) && this.dataSource != null) {
            try {
                this.topic = this.dataSource.getTopic(monitor, streamInfo.getTopic());
            }
            catch (DBException e) {
                log.error((Object)"Error linking topic", (Throwable)e);
            }
        }
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getName() {
        return this.stream.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Property(order=1, viewable=true)
    public KSQLTopic getTopic() {
        return this.topic;
    }

    @Property(order=2, viewable=true)
    public String getKeyFormat() {
        return this.stream.getKeyFormat();
    }

    @Property(order=3, viewable=true)
    public String getValueFormat() {
        return this.stream.getValueFormat();
    }

    @Property(order=4, viewable=true)
    public boolean isWindowed() {
        return this.stream.isWindowed();
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.filter", "data.insert"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            KSQLSession ksqlSession = (KSQLSession)session;
            DBCStatistics statistics = new DBCStatistics();
            StringBuilder query = new StringBuilder();
            query.append("Select * from ").append(this.getName());
            if (dataFilter != null && dataFilter.hasConditions()) {
                SQLUtils.appendQueryConditions((DBPDataSource)session.getDataSource(), (StringBuilder)query, (String)this.getName(), (DBDDataFilter)dataFilter);
            }
            Throwable throwable = null;
            Object var16_15 = null;
            try (KSQLSelectStatement statement = new KSQLSelectStatement(ksqlSession, query.append(";").toString());){
                statement.setStatementSource(source);
                statement.setLimit(firstRow, maxRows);
                statistics.setQueryText(statement.getQueryString());
                statistics.addStatementsCount();
                if (!statement.executeStatement()) return statistics;
                Throwable throwable2 = null;
                Object var19_20 = null;
                try {
                    DBCResultSet resultSet;
                    block20: {
                        resultSet = statement.openResultSet();
                        if (resultSet != null) break block20;
                        DBCStatistics dBCStatistics = statistics;
                        if (resultSet == null) return dBCStatistics;
                        resultSet.close();
                        return dBCStatistics;
                    }
                    try {
                        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                        DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                        return statistics;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
        return 0L;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.ddl = null;
        this.attributeCache.clearCache();
        return this;
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        throw new DBCException("KSQL insert is currently not supported");
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] updateAttributes, @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCException("KSQL is insert only");
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] keyAttributes, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCException("KSQL is insert only");
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @Nullable
    @Association
    public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return monitor.isForceCacheUsage() ? this.attributeCache.getCachedObjects() : this.attributeCache.getAllObjects(monitor, this.dataSource);
    }

    @Nullable
    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)this.attributeCache.getObject(monitor, (DBSObject)this.dataSource, attributeName);
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @Nullable
    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.ddl == null) {
            try {
                this.ddl = ((SourceDescription)this.executionContext.getKsqlClient().describeSource(this.getName()).get(this.executionContext.getRequestTimeout(), TimeUnit.MILLISECONDS)).sqlStatement();
            }
            catch (Exception e) {
                throw new DBException("Error reading object definition text", (Throwable)e);
            }
        }
        return this.ddl;
    }

    public class AttributeCache
    extends BasicObjectCache<KSQLDataSource, KSQLField> {
        @NotNull
        public List<KSQLField> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable KSQLDataSource ksqlDataSource) throws DBException {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (!this.isFullyCached()) {
                ArrayList<KSQLField> result = new ArrayList<KSQLField>();
                try {
                    SourceDescription description = (SourceDescription)KSQLStream.this.executionContext.getKsqlClient().describeSource(KSQLStream.this.getName()).get(KSQLStream.this.executionContext.getRequestTimeout(), TimeUnit.SECONDS);
                    List fields = description.fields();
                    for (FieldInfo field : fields) {
                        KSQLField ksqlField = new KSQLField(field, KSQLStream.this.dataSource, KSQLStream.this);
                        result.add(ksqlField);
                    }
                }
                catch (Throwable e) {
                    throw new DBCException("Error reading KSQL streams", e);
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

