/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.exec.KSQLExecutionContext;
import com.dbeaver.db.kafka.model.KSQLDataSource;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ServerInfo;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.impl.AbstractDataSourceInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class KSQLDataSourceInfo
extends AbstractDataSourceInfo {
    private static final Log log = Log.getLog(KSQLDataSourceInfo.class);
    public static final String DRIVER_BUNDLE_NAME = "org.jkiss.bundle.kafka-ksql";
    private final KSQLDataSource dataSource;
    private Version serverVersion;

    public KSQLDataSourceInfo(@NotNull KSQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getDatabaseProductName() {
        return "Kafka";
    }

    public String getDatabaseProductVersion() {
        Client client = ((KSQLExecutionContext)this.dataSource.getDefaultContext()).getKsqlClient();
        try {
            return ((ServerInfo)client.serverInfo().get(((KSQLExecutionContext)this.dataSource.getDefaultContext()).getRequestTimeout(), TimeUnit.MILLISECONDS)).getServerVersion();
        }
        catch (Throwable e) {
            log.debug((Object)"Error getting Kafka broker version", e);
            return this.getDatabaseVersion().toString();
        }
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)DRIVER_BUNDLE_NAME);
        if (bundle == null) {
            throw new IllegalStateException("Kafka driver bundle 'org.jkiss.bundle.kafka-ksql' not found");
        }
        return bundle;
    }

    public Version getDatabaseVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = new Version(1, 0, 0);
        }
        return this.serverVersion;
    }

    public String getDriverName() {
        return "KSQL Client";
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return null;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsResultSetLimit() {
        return true;
    }

    public boolean supportsResultSetScroll() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return true;
    }
}

