/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.exec;

import com.dbeaver.db.kafka.KSQLUtils;
import com.dbeaver.db.kafka.exec.KSQLSession;
import com.google.gson.Gson;
import io.confluent.ksql.api.client.Client;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class KSQLBaseStatement
extends AbstractStatement<KSQLSession> {
    private static final Log log = Log.getLog(KSQLBaseStatement.class);
    static final Gson gson = new Gson();
    private final String query;

    public KSQLBaseStatement(@NotNull KSQLSession session, @NotNull String query) {
        super((DBCSession)session);
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @Nullable
    public String getQueryString() {
        return this.query;
    }

    public boolean executeStatement() throws DBCException {
        Exception executeError = null;
        try {
            this.beforeExecute();
            Client.HttpResponse httpResponse = KSQLUtils.sendKSQLRequest(((KSQLSession)this.getSession()).getExecutionContext(), this.getQueryString());
            if (httpResponse.status() != 200) {
                String errorMessage = new String(httpResponse.body());
                if (CommonUtils.isEmpty((String)errorMessage)) {
                    throw new DBCException("Error executing the KSQL statement status: " + httpResponse.status());
                }
                Map map = (Map)gson.fromJson(errorMessage, Map.class);
                String message = (String)map.get("message");
                throw new DBException(message);
            }
            return true;
        }
        catch (Exception e) {
            executeError = e;
            if (e instanceof DBCException) {
                throw (DBCException)e;
            }
            throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((KSQLSession)this.getSession()).getExecutionContext());
        }
        finally {
            if (((KSQLSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    @Nullable
    public DBCResultSet openResultSet() {
        return null;
    }

    public long getUpdateRowCount() {
        return 0L;
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void setLimit(long offset, long limit) {
    }

    @Nullable
    public Throwable[] getStatementWarnings() {
        return null;
    }

    public void setStatementTimeout(int timeout) {
    }

    public void setResultsFetchSize(int fetchSize) {
    }

    protected void beforeExecute() {
        if (((KSQLSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
    }
}

