/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka;

import com.dbeaver.db.kafka.exec.KSQLExecutionContext;
import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.ColumnType;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;

public class KSQLUtils {
    private static final Log log = Log.getLog(KSQLUtils.class);

    public static DBPDataKind convertKSQLColumnType(ColumnType.Type type) {
        switch (type) {
            case ARRAY: {
                return DBPDataKind.ARRAY;
            }
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: {
                return DBPDataKind.NUMERIC;
            }
            case STRING: {
                return DBPDataKind.STRING;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return DBPDataKind.DATETIME;
            }
            case MAP: 
            case STRUCT: {
                return DBPDataKind.STRUCT;
            }
            case BYTES: {
                return DBPDataKind.BINARY;
            }
            case BOOLEAN: {
                return DBPDataKind.BOOLEAN;
            }
        }
        return null;
    }

    @NotNull
    public static Client.HttpResponse sendKSQLRequest(@NotNull KSQLExecutionContext context, @Nullable String request) throws ExecutionException, InterruptedException, TimeoutException {
        return (Client.HttpResponse)context.getKsqlClient().buildRequest("POST", "/ksql").payload("ksql", (Object)(request != null ? request : "")).send().get(context.getRequestTimeout(), TimeUnit.MILLISECONDS);
    }
}

