/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.poi.xssf.streaming.CommentsTableBase;
import com.github.pjfanning.poi.xssf.streaming.MapBackedCommentsTable;
import com.github.pjfanning.poi.xssf.streaming.MapBackedSharedStringsTable;
import com.github.pjfanning.poi.xssf.streaming.SharedStringsTableBase;
import com.github.pjfanning.poi.xssf.streaming.TempFileCommentsTable;
import com.github.pjfanning.poi.xssf.streaming.TempFileSharedStringsTable;
import com.github.pjfanning.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.SharedStringsTable;

public final class PoiSharedStringsSupport {
    public static Comments createTempFileCommentsTable(StreamingReader.Builder builder) throws IOException {
        return new TempFileCommentsTable(builder.encryptCommentsTempFile(), builder.fullFormatRichText());
    }

    public static Comments createMapBackedCommentsTable(StreamingReader.Builder builder) {
        return new MapBackedCommentsTable(builder.fullFormatRichText());
    }

    public static SharedStringsTable createTempFileSharedStringsTable(StreamingReader.Builder builder) throws IOException {
        return new TempFileSharedStringsTable(builder.encryptSstTempFile(), builder.fullFormatRichText());
    }

    public static SharedStringsTable createTempFileSharedStringsTable(OPCPackage pkg, StreamingReader.Builder builder) throws IOException {
        return new TempFileSharedStringsTable(pkg, builder.encryptSstTempFile(), builder.fullFormatRichText());
    }

    public static SharedStringsTable createMapBackedSharedStringsTable(StreamingReader.Builder builder) {
        return new MapBackedSharedStringsTable(builder.fullFormatRichText());
    }

    public static SharedStringsTable createMapBackedSharedStringsTable(OPCPackage pkg, StreamingReader.Builder builder) throws IOException {
        return new MapBackedSharedStringsTable(pkg, builder.fullFormatRichText());
    }

    public static void readComments(Comments comments, InputStream inputStream) throws IOException {
        if (comments instanceof CommentsTableBase) {
            ((CommentsTableBase)comments).readFrom(inputStream);
        }
    }

    public static String getSharedString(SharedStrings sst, int index) {
        if (sst instanceof SharedStringsTableBase) {
            return ((SharedStringsTableBase)sst).getString(index);
        }
        return sst.getItemAt(index).getString();
    }

    private PoiSharedStringsSupport() {
    }
}

