/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupRequestBase;
import com.azure.resourcemanager.postgresqlflexibleserver.models.BackupSettings;
import java.io.IOException;

public final class LtrPreBackupRequest
extends BackupRequestBase {
    private static final ClientLogger LOGGER = new ClientLogger(LtrPreBackupRequest.class);

    @Override
    public LtrPreBackupRequest withBackupSettings(BackupSettings backupSettings) {
        super.withBackupSettings(backupSettings);
        return this;
    }

    @Override
    public void validate() {
        if (this.backupSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property backupSettings in model LtrPreBackupRequest"));
        }
        this.backupSettings().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("backupSettings", (JsonSerializable)this.backupSettings());
        return jsonWriter.writeEndObject();
    }

    public static LtrPreBackupRequest fromJson(JsonReader jsonReader) throws IOException {
        return (LtrPreBackupRequest)jsonReader.readObject(reader -> {
            LtrPreBackupRequest deserializedLtrPreBackupRequest = new LtrPreBackupRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupSettings".equals(fieldName)) {
                    deserializedLtrPreBackupRequest.withBackupSettings(BackupSettings.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLtrPreBackupRequest;
        });
    }
}

