/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationNameAvailabilityResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.MigrationNameAvailabilityResourceImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationNameAvailabilityResource;
import com.azure.resourcemanager.postgresqlflexibleserver.models.ResourceProviders;

public final class ResourceProvidersImpl
implements ResourceProviders {
    private static final ClientLogger LOGGER = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MigrationNameAvailabilityResource> checkMigrationNameAvailabilityWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters, Context context) {
        Response<MigrationNameAvailabilityResourceInner> inner = this.serviceClient().checkMigrationNameAvailabilityWithResponse(subscriptionId, resourceGroupName, targetDbServerName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MigrationNameAvailabilityResourceImpl((MigrationNameAvailabilityResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public MigrationNameAvailabilityResource checkMigrationNameAvailability(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationNameAvailabilityResourceInner parameters) {
        MigrationNameAvailabilityResourceInner inner = this.serviceClient().checkMigrationNameAvailability(subscriptionId, resourceGroupName, targetDbServerName, parameters);
        if (inner != null) {
            return new MigrationNameAvailabilityResourceImpl(inner, this.manager());
        }
        return null;
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

