/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnection;
import com.azure.resourcemanager.postgresqlflexibleserver.models.PrivateEndpointConnections;

public final class PrivateEndpointConnectionsImpl
implements PrivateEndpointConnections {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionsImpl.class);
    private final PrivateEndpointConnectionsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateEndpointConnection> getWithResponse(String resourceGroupName, String serverName, String privateEndpointConnectionName, Context context) {
        Response<PrivateEndpointConnectionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, privateEndpointConnectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateEndpointConnection get(String resourceGroupName, String serverName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner inner = this.serviceClient().get(resourceGroupName, serverName, privateEndpointConnectionName);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    private PrivateEndpointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

