/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.MigrationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.MigrationResourceInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.PostgreSqlManagementClientImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationListFilter;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceForPatch;
import com.azure.resourcemanager.postgresqlflexibleserver.models.MigrationResourceListResult;
import reactor.core.publisher.Mono;

public final class MigrationsClientImpl
implements MigrationsClient {
    private final MigrationsService service;
    private final PostgreSqlManagementClientImpl client;

    MigrationsClientImpl(PostgreSqlManagementClientImpl client) {
        this.service = (MigrationsService)RestProxy.create(MigrationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> createWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> createWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MigrationResourceInner> createAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters) {
        return this.createWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((MigrationResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MigrationResourceInner> createWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters, Context context) {
        return (Response)this.createWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MigrationResourceInner create(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceInner parameters) {
        return (MigrationResourceInner)((Object)this.createWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> getWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> getWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MigrationResourceInner> getAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        return this.getWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((MigrationResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MigrationResourceInner> getWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        return (Response)this.getWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MigrationResourceInner get(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        return (MigrationResourceInner)((Object)this.getWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MigrationResourceInner>> updateWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MigrationResourceInner>> updateWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MigrationResourceInner> updateAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters) {
        return this.updateWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((MigrationResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MigrationResourceInner> updateWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters, Context context) {
        return (Response)this.updateWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MigrationResourceInner update(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, MigrationResourceForPatch parameters) {
        return (MigrationResourceInner)((Object)this.updateWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        if (migrationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        return this.deleteWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName, Context context) {
        return (Response)this.deleteWithResponseAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String subscriptionId, String resourceGroupName, String targetDbServerName, String migrationName) {
        this.deleteWithResponse(subscriptionId, resourceGroupName, targetDbServerName, migrationName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerSinglePageAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTargetServer(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MigrationResourceListResult)res.getValue()).value(), ((MigrationResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerSinglePageAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionId is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (targetDbServerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbServerName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTargetServer(this.client.getEndpoint(), this.client.getApiVersion(), subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MigrationResourceListResult)res.getValue()).value(), ((MigrationResourceListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter) {
        return new PagedFlux(() -> this.listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter), nextLink -> this.listByTargetServerNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName, String targetDbServerName) {
        MigrationListFilter migrationListFilter = null;
        return new PagedFlux(() -> this.listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter), nextLink -> this.listByTargetServerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MigrationResourceInner> listByTargetServerAsync(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        return new PagedFlux(() -> this.listByTargetServerSinglePageAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, context), nextLink -> this.listByTargetServerNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName, String targetDbServerName) {
        MigrationListFilter migrationListFilter = null;
        return new PagedIterable(this.listByTargetServerAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MigrationResourceInner> listByTargetServer(String subscriptionId, String resourceGroupName, String targetDbServerName, MigrationListFilter migrationListFilter, Context context) {
        return new PagedIterable(this.listByTargetServerAsync(subscriptionId, resourceGroupName, targetDbServerName, migrationListFilter, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByTargetServerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MigrationResourceListResult)res.getValue()).value(), ((MigrationResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MigrationResourceInner>> listByTargetServerNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByTargetServerNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MigrationResourceListResult)res.getValue()).value(), ((MigrationResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PostgreSqlManagement")
    public static interface MigrationsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationResourceInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @PathParam(value="migrationName") String var6, @BodyParam(value="application/json") MigrationResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @PathParam(value="migrationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationResourceInner>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @PathParam(value="migrationName") String var6, @BodyParam(value="application/json") MigrationResourceForPatch var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations/{migrationName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @PathParam(value="migrationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{targetDbServerName}/migrations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationResourceListResult>> listByTargetServer(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="targetDbServerName") String var5, @QueryParam(value="migrationListFilter") MigrationListFilter var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MigrationResourceListResult>> listByTargetServerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

