/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.provider;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;

public class PrefPageCloudServiceAccounts
extends AbstractPrefPage {
    private static final Log log = Log.getLog(PrefPageCloudServiceAccounts.class);
    private CPCloudConfiguration<?> cloudConfiguration;
    private Combo saCombo;
    private Composite configPlaceholder;
    private List<CPCloudServiceAccount> serviceAccounts = new ArrayList<CPCloudServiceAccount>();
    private IObjectPropertyConfigurator<CPCloudConfiguration, CPCloudServiceAccount> credentialsConfigurator;
    private Button deleteButton;

    @NotNull
    private CPCloudConfiguration<?> getCloudConfiguration() {
        return this.cloudConfiguration;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite saGroup = new Composite(parent, 0);
        saGroup.setLayout((Layout)new GridLayout(2, false));
        UIUtils.createControlLabel((Composite)saGroup, (String)"Service Account");
        Composite controlComposite = UIUtils.createComposite((Composite)saGroup, (int)3);
        controlComposite.setLayoutData((Object)new GridData(768));
        this.saCombo = new Combo(controlComposite, 12);
        this.saCombo.setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)controlComposite, (String)"Create", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.createNewAccount()));
        this.deleteButton = UIUtils.createDialogButton((Composite)controlComposite, (String)"Delete", (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.deleteCurAccount()));
        this.deleteButton.setEnabled(false);
        this.saCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = PrefPageCloudServiceAccounts.this.saCombo.getSelectionIndex() >= 0;
                PrefPageCloudServiceAccounts.this.deleteButton.setEnabled(isSelected);
                PrefPageCloudServiceAccounts.this.showAccountPreferences();
            }
        });
        this.configPlaceholder = UIUtils.createComposite((Composite)saGroup, (int)2);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.configPlaceholder.setLayoutData((Object)gd);
        return saGroup;
    }

    private void createNewAccount() {
        String accountId = EnterNameDialog.chooseName((Shell)this.getShell(), (String)"Enter account unique ID", (String)"service-task-manager");
        if (accountId == null) {
            return;
        }
        if (this.serviceAccounts.stream().anyMatch(sa -> sa.getId().equals(accountId))) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Bad account ID", (String)("Service account '" + accountId + "' already exists"), (int)1);
            return;
        }
        CPCloudConfigurationProvider<?> configurationProvider = this.getConfigurationProvider();
        try {
            CPCloudServiceAccount serviceAccount = (CPCloudServiceAccount)configurationProvider.getCloudServiceAccountClass().getConstructor(String.class).newInstance(accountId);
            this.serviceAccounts.add(serviceAccount);
            this.saCombo.add(accountId);
            this.saCombo.select(this.serviceAccounts.size() - 1);
            this.showAccountPreferences();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void deleteCurAccount() {
        CPCloudServiceAccount curServiceAccount = this.getCurServiceAccount();
        if (curServiceAccount == null) {
            return;
        }
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Delete service account", (String)("Are you sure you want to delete service account '" + curServiceAccount.getId() + "'?"))) {
            return;
        }
        int index = this.serviceAccounts.indexOf(curServiceAccount);
        this.saCombo.remove(index);
        this.serviceAccounts.remove(curServiceAccount);
        if (!this.serviceAccounts.isEmpty()) {
            if (index >= this.serviceAccounts.size()) {
                this.saCombo.select(this.serviceAccounts.size() - 1);
            } else {
                this.saCombo.select(index);
            }
        }
        this.showAccountPreferences();
    }

    public void loadSettings(CPCloudConfiguration<?> cloudConfiguration) {
        this.cloudConfiguration = cloudConfiguration;
        this.saCombo.removeAll();
        try {
            this.serviceAccounts = new ArrayList<CPCloudServiceAccount>(this.cloudConfiguration.getServiceAccounts());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Service account load error", "Error loading service accounts", (Throwable)e);
        }
        for (CPCloudServiceAccount sa : this.serviceAccounts) {
            this.saCombo.add(sa.getId());
        }
        if (!this.serviceAccounts.isEmpty()) {
            this.saCombo.select(0);
        }
        this.deleteButton.setEnabled(this.saCombo.getSelectionIndex() >= 0);
        this.showAccountPreferences();
    }

    private void showAccountPreferences() {
        UIPropertyConfiguratorDescriptor configDescriptor;
        UIUtils.disposeChildControls((Composite)this.configPlaceholder);
        CPCloudServiceAccount sa = this.getCurServiceAccount();
        CPCloudConfigurationProvider<?> ccProvider = this.getConfigurationProvider();
        if (ccProvider != null && sa != null && (configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(ccProvider.getCloudServiceAccountClass().getName())) != null) {
            try {
                this.credentialsConfigurator = configDescriptor.createConfigurator();
                this.credentialsConfigurator.createControl(this.configPlaceholder, null, () -> {});
                this.credentialsConfigurator.loadSettings((Object)sa);
            }
            catch (DBException e) {
                log.error((Object)"Error creating UI control", (Throwable)e);
            }
        }
    }

    @Nullable
    private CPCloudConfigurationProvider<?> getConfigurationProvider() {
        CPCloudConfigurationProvider ccProvider = CPCloudUtils.getConfigurationProvider(this.getCloudConfiguration().getClass());
        return ccProvider;
    }

    private CPCloudServiceAccount getCurServiceAccount() {
        int selectionIndex = this.saCombo.getSelectionIndex();
        return selectionIndex < 0 ? null : this.serviceAccounts.get(selectionIndex);
    }

    protected void performApply() {
        CPCloudServiceAccount curServiceAccount = this.getCurServiceAccount();
        if (curServiceAccount != null && this.credentialsConfigurator != null) {
            this.credentialsConfigurator.saveSettings((Object)curServiceAccount);
        }
        try {
            this.cloudConfiguration.setServiceAccounts(this.serviceAccounts);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Service account save error", "Error saving service accounts", (Throwable)e);
        }
        super.performApply();
    }

    public void initialize(CPCloudConfiguration<?> cloudConfiguration) {
        try {
            this.cloudConfiguration = cloudConfiguration;
            this.serviceAccounts = new ArrayList<CPCloudServiceAccount>(cloudConfiguration.getServiceAccounts());
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Service account load error", "Error loading service accounts", (Throwable)e);
        }
    }
}

