/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.provider;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudTunnelManager;
import com.dbeaver.cloud.ui.provider.BaseCloudConfigurationEditor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretSubject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.preferences.PrefPageNetworkProfiles;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageCloudNetworkProfiles<EDITOR extends BaseCloudConfigurationEditor>
extends PrefPageNetworkProfiles {
    private final EDITOR editor;
    private CPCloud<?, ?> cloud;
    private Combo zoneCombo;
    private Button autoAssignCheck;

    public PrefPageCloudNetworkProfiles(@NotNull EDITOR editor) {
        this.editor = editor;
    }

    @NotNull
    private CPCloudConfiguration<?> getCloudConfiguration() {
        return ((BaseCloudConfigurationEditor)this.editor).getCurConfiguration();
    }

    private CPCloudTunnelManager getTunnelManager() {
        return (CPCloudTunnelManager)this.getCloud();
    }

    private CPCloud<?, ?> getCloud() {
        if (this.cloud == null) {
            this.cloud = ((BaseCloudConfigurationEditor)this.editor).createCloudFromConfiguration(this.getCloudConfiguration());
        }
        return this.cloud;
    }

    protected DBSSecretController getSecretController() throws DBException {
        return DBSSecretController.getGlobalSecretController();
    }

    protected List<DBWNetworkProfile> getDefaultNetworkProfiles() {
        return this.getTunnelManager().getTunnelProfiles();
    }

    protected void updateNetworkProfiles(List<DBWNetworkProfile> allProfiles) {
        this.getTunnelManager().setTunnelProfiles(allProfiles);
    }

    protected boolean deleteProfile(DBWNetworkProfile selectedProfile) {
        CPCloudTunnelManager tunnelManager;
        ArrayList profiles;
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_delete_confirmation_title, (String)("Are you sure you want to delete network profile '" + selectedProfile.getProfileName() + "' from cloud '" + this.cloud.getName() + "' configuration?")) && (profiles = new ArrayList((tunnelManager = this.getTunnelManager()).getTunnelProfiles())).remove(selectedProfile)) {
            tunnelManager.setTunnelProfiles(profiles);
            return true;
        }
        return false;
    }

    protected boolean isHandlerApplicable(DBWHandlerDescriptor nhd) {
        return nhd.getId().equals("ssh_tunnel");
    }

    protected boolean isInitOnCreate() {
        return false;
    }

    protected void updateSelectedProfile(DBWNetworkProfile profile) {
        super.updateSelectedProfile(profile);
        if (profile != null) {
            String profileZone;
            boolean autoAssign = CommonUtils.toBoolean(profile.getProperties().get("cloud-network-profile-auto-assign"));
            this.autoAssignCheck.setSelection(autoAssign);
            if (this.zoneCombo != null && !CommonUtils.isEmpty((String)(profileZone = CommonUtils.toString(profile.getProperties().get("cloud-network-profile-default-zone"), null)))) {
                this.zoneCombo.setText(profileZone);
            }
        }
    }

    protected void preCreateHandlerControls(Composite composite) {
        super.preCreateHandlerControls(composite);
        Composite controlsPanel = new Composite(composite, 0);
        controlsPanel.setLayout((Layout)new GridLayout(2, false));
        this.autoAssignCheck = UIUtils.createCheckbox((Composite)controlsPanel, (String)"Assign automatically", (String)"Assign this tunnel for all database connections", (boolean)false, (int)1);
        Object[] enabledZones = this.getCloudConfiguration().getEnabledZones();
        if (!ArrayUtils.isEmpty((Object[])enabledZones)) {
            Composite zoneSelector = UIUtils.createComposite((Composite)controlsPanel, (int)2);
            this.zoneCombo = UIUtils.createLabelCombo((Composite)zoneSelector, (String)"Zone", (String)"Cloud zone in which this tunnel is located", (int)12);
            Object[] objectArray = enabledZones;
            int n = enabledZones.length;
            int n2 = 0;
            while (n2 < n) {
                Object zone = objectArray[n2];
                this.zoneCombo.add((String)zone);
                ++n2;
            }
        }
    }

    protected void postCreateHandlerControls(Composite composite) {
        super.postCreateHandlerControls(composite);
    }

    public void saveSettings(DBWNetworkProfile profile) {
        super.saveSettings(profile);
        if (profile != this.getSelectedProfile()) {
            return;
        }
        profile.getProperties().put("cloud-network-profile-auto-assign", String.valueOf(this.autoAssignCheck.getSelection()));
        if (this.zoneCombo != null) {
            profile.getProperties().put("cloud-network-profile-default-zone", this.zoneCombo.getText());
        }
    }

    protected DBWNetworkProfile createNewProfile(@Nullable DBWNetworkProfile sourceProfile) {
        String profileName = sourceProfile == null ? "" : sourceProfile.getProfileName();
        CPCloudTunnelManager tunnelManager = this.getTunnelManager();
        while (true) {
            if (CommonUtils.isEmptyTrimmed((String)(profileName = EnterNameDialog.chooseName((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_create_dialog_profile_name, (String)profileName)))) {
                return null;
            }
            String finalProfileName = profileName = profileName.trim();
            if (!tunnelManager.getTunnelProfiles().stream().anyMatch(p -> p.getProfileSource().equals(this.getProfileSource()) && p.getProfileName().equals(finalProfileName))) break;
            UIUtils.showMessageBox((Shell)this.getShell(), (String)UIConnectionMessages.pref_page_network_profiles_tool_create_dialog_error_title, (String)("Network profile '" + profileName + "' already exists in cloud '" + this.cloud.getName() + "' configuration?"), (int)1);
        }
        DBWNetworkProfile newProfile = new DBWNetworkProfile();
        newProfile.setProfileName(profileName);
        if (this.cloud.getCloudConfiguration() instanceof DBSSecretSubject) {
            newProfile.setSecretSubject((DBSSecretSubject)this.cloud.getCloudConfiguration());
        }
        ArrayList<DBWNetworkProfile> profiles = new ArrayList<DBWNetworkProfile>(tunnelManager.getTunnelProfiles());
        profiles.add(newProfile);
        tunnelManager.setTunnelProfiles(profiles);
        return newProfile;
    }

    private String getProfileSource() {
        if (this.cloud.getCloudConfiguration() instanceof DBSSecretSubject) {
            ((DBSSecretSubject)this.cloud.getCloudConfiguration()).getSecretSubjectId();
        }
        return null;
    }
}

