/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.provider;

import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudSessionManager;
import com.dbeaver.cloud.ui.explorer.CloudConfigurationDescriptor;
import com.dbeaver.cloud.ui.provider.PrefPageCloudNetworkProfiles;
import com.dbeaver.cloud.ui.provider.PrefPageCloudServiceAccounts;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.GlobalUIPropertyTester;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;

public abstract class BaseCloudConfigurationEditor<CLOUD extends CPCloud<?, ?>, CONFIG extends CPCloudConfiguration<?>, CONFIGURATOR extends DatabaseNativeAuthModelConfigurator>
implements IObjectPropertyConfigurator<CloudConfigurationDescriptor, CONFIG> {
    private static final Log log = Log.getLog(BaseCloudConfigurationEditor.class);
    private CONFIG curConfiguration;
    private CONFIGURATOR dataSourceConfigurator;
    protected Composite mainGroup;
    private Button refreshSessionButton;
    private Button closeSessionButton;
    private PrefPageCloudNetworkProfiles<BaseCloudConfigurationEditor> networkProfilesPage;
    private PrefPageCloudServiceAccounts saPage;

    protected abstract CONFIGURATOR createAuthConfigurator(Composite var1, Runnable var2);

    protected abstract CLOUD createCloudFromConfiguration(CONFIG var1);

    protected abstract boolean isSessionOpen(CONFIGURATOR var1, CONFIG var2);

    protected boolean supportsSessionManager() {
        return true;
    }

    protected boolean supportsTunnelManager() {
        return true;
    }

    public CONFIG getCurConfiguration() {
        return this.curConfiguration;
    }

    public CONFIGURATOR getDataSourceConfigurator() {
        return this.dataSourceConfigurator;
    }

    public void createControl(@NotNull Composite parent, CloudConfigurationDescriptor object, @NotNull Runnable propertyChangeListener) {
        CTabFolder configTabs = new CTabFolder(parent, 0x800080);
        this.createGeneralTab(configTabs, propertyChangeListener);
        this.createExtraTabs(configTabs, propertyChangeListener);
        if (this.supportsTunnelManager()) {
            this.createTunnelsTabs(configTabs, propertyChangeListener);
        }
        if (DBWorkbench.isDistributed() && GlobalUIPropertyTester.canManageProjects()) {
            this.createServiceAccountsTab(configTabs);
        }
        this.createAdditionTabs(configTabs);
        configTabs.setSelection(0);
    }

    protected void createAdditionTabs(CTabFolder configTabs) {
    }

    protected void createExtraTabs(CTabFolder configTabs, Runnable propertyChangeListener) {
    }

    public void createGeneralTab(final CTabFolder parent, Runnable propertyChangeListener) {
        Composite generalGroup = new Composite((Composite)parent, 0);
        generalGroup.setLayout((Layout)new GridLayout(1, false));
        this.mainGroup = UIUtils.createComposite((Composite)generalGroup, (int)2);
        this.mainGroup.setLayoutData((Object)new GridData(1808));
        this.dataSourceConfigurator = this.createAuthConfigurator(this.mainGroup, propertyChangeListener);
        UIUtils.createEmptyLabel((Composite)generalGroup, (int)1, (int)1).setLayoutData((Object)new GridData(1808));
        final Composite btnComposite = UIUtils.createComposite((Composite)generalGroup, (int)4);
        btnComposite.setLayoutData((Object)new GridData(768));
        UIUtils.createEmptyLabel((Composite)btnComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        if (this.supportsSessionManager()) {
            UIUtils.createDialogButton((Composite)btnComposite, (String)CloudUIMessages.cloud_configurator_dialog_button_test_connection, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseCloudConfigurationEditor.this.saveSettings(BaseCloudConfigurationEditor.this.curConfiguration);
                    try {
                        BaseCloudConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> BaseCloudConfigurationEditor.this.testCloudConnection(monitor, BaseCloudConfigurationEditor.this.curConfiguration));
                    }
                    catch (InvocationTargetException ex) {
                        DBWorkbench.getPlatformUI().showError("Cloud connect error", "Error during cloud connect", ex.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.refreshSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)CloudUIMessages.cloud_configurator_dialog_button_refresh_session, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseCloudConfigurationEditor.this.saveSettings(BaseCloudConfigurationEditor.this.curConfiguration);
                    try {
                        BaseCloudConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> BaseCloudConfigurationEditor.this.refreshCloudSession(monitor, BaseCloudConfigurationEditor.this.curConfiguration));
                    }
                    catch (InvocationTargetException ex) {
                        DBWorkbench.getPlatformUI().showError("Session refresh error", "Error during session refresh", ex.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.closeSessionButton = UIUtils.createDialogButton((Composite)btnComposite, (String)CloudUIMessages.cloud_configurator_dialog_button_end_session, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!UIUtils.confirmAction((Shell)btnComposite.getShell(), (String)"End SSO Session", (String)"Are you sure you want to end active SSO session?")) {
                        return;
                    }
                    try {
                        BaseCloudConfigurationEditor.this.getRunnableContext(parent).run(true, true, monitor -> BaseCloudConfigurationEditor.this.closeCloudSession(monitor, BaseCloudConfigurationEditor.this.curConfiguration));
                    }
                    catch (InvocationTargetException ex) {
                        DBWorkbench.getPlatformUI().showError("Session close error", "Error during session close", ex.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
        CTabItem regionsTab = new CTabItem(parent, 0);
        regionsTab.setText(CloudUIMessages.cloud_configurator_tab_item_authentication);
        regionsTab.setControl((Control)generalGroup);
    }

    private void createTunnelsTabs(final CTabFolder parent, Runnable propertyChangeListener) {
        final Composite generalGroup = new Composite((Composite)parent, 0);
        generalGroup.setLayout((Layout)new FillLayout());
        final CTabItem tunnelsTab = new CTabItem(parent, 0);
        tunnelsTab.setText("Tunnels");
        tunnelsTab.setControl((Control)generalGroup);
        this.networkProfilesPage = new PrefPageCloudNetworkProfiles<BaseCloudConfigurationEditor>(this);
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (parent.getSelection() == tunnelsTab) {
                    parent.getShell().setRedraw(false);
                    try {
                        BaseCloudConfigurationEditor.this.networkProfilesPage.createControl(generalGroup);
                        BaseCloudConfigurationEditor.this.networkProfilesPage.loadSettings();
                        UIUtils.resizeShell((Shell)parent.getShell());
                        parent.getShell().layout(true, true);
                    }
                    finally {
                        parent.getShell().setRedraw(true);
                    }
                    parent.removeSelectionListener((SelectionListener)this);
                }
            }
        });
    }

    private void createServiceAccountsTab(final CTabFolder parent) {
        Composite saTabGroup = new Composite((Composite)parent, 0);
        saTabGroup.setLayout((Layout)new FillLayout());
        final CTabItem saTab = new CTabItem(parent, 0);
        saTab.setText("Service Accounts");
        saTab.setControl((Control)saTabGroup);
        this.saPage = new PrefPageCloudServiceAccounts();
        this.saPage.createControl(saTabGroup);
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (parent.getSelection() == saTab) {
                    BaseCloudConfigurationEditor.this.saPage.loadSettings((CPCloudConfiguration<?>)BaseCloudConfigurationEditor.this.getCurConfiguration());
                    parent.removeSelectionListener((SelectionListener)this);
                }
            }
        });
    }

    @NotNull
    public DBRRunnableContext getRunnableContext(CTabFolder parent) {
        Object context = parent.getShell().getData() instanceof IRunnableContext ? new RunnableContextDelegate((IRunnableContext)parent.getShell().getData()) : UIUtils.getDialogRunnableContext();
        return context;
    }

    private void testCloudConnection(DBRProgressMonitor monitor, CONFIG cfg) throws InvocationTargetException {
        monitor.beginTask("Test cloud connection", 1);
        CLOUD cloud = this.createCloudFromConfiguration(cfg);
        if (cloud instanceof CPCloudSessionManager) {
            CPCloudSessionManager sm = (CPCloudSessionManager)cloud;
            try {
                try {
                    String response = sm.testConnection(monitor);
                    UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)"Success", (String)("Cloud connection established successfully: " + response), (int)2));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
                UIUtils.asyncExec(this::updateSessionActions);
            }
        }
    }

    private void refreshCloudSession(DBRProgressMonitor monitor, CONFIG cfg) throws InvocationTargetException {
        monitor.beginTask("Refresh cloud connection", 1);
        CLOUD cloud = this.createCloudFromConfiguration(cfg);
        if (cloud instanceof CPCloudSessionManager) {
            CPCloudSessionManager sm = (CPCloudSessionManager)cloud;
            try {
                try {
                    String response = sm.refreshSession(monitor);
                    UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)"Success", (String)("Cloud session has been refreshed" + response), (int)2));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
                UIUtils.asyncExec(this::updateSessionActions);
            }
        }
    }

    private void closeCloudSession(DBRProgressMonitor monitor, CONFIG cfg) throws InvocationTargetException {
        monitor.beginTask("Close cloud connection", 1);
        CLOUD cloud = this.createCloudFromConfiguration(cfg);
        if (cloud instanceof CPCloudSessionManager) {
            CPCloudSessionManager sm = (CPCloudSessionManager)cloud;
            try {
                try {
                    sm.closeSession(monitor);
                    UIUtils.asyncExec(() -> UIUtils.showMessageBox(null, (String)"Terminated", (String)"Cloud session was terminated", (int)2));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
                UIUtils.asyncExec(this::updateSessionActions);
            }
        }
    }

    protected void updateSessionActions() {
        boolean hasSessionToken = this.isSessionOpen(this.dataSourceConfigurator, this.curConfiguration);
        if (this.refreshSessionButton != null) {
            this.refreshSessionButton.setEnabled(hasSessionToken);
        }
        if (this.closeSessionButton != null) {
            this.closeSessionButton.setEnabled(hasSessionToken);
        }
    }

    public void resetSettings(@NotNull CONFIG configuration) {
    }

    public boolean isComplete() {
        return this.dataSourceConfigurator.isComplete();
    }

    public void loadSettings(@NotNull CONFIG config) {
        this.curConfiguration = config;
        if (this.curConfiguration.isDefaultConfiguration() && !this.isDefaultConfigurationEditable()) {
            ControlEnableState.disable((Control)this.mainGroup);
        }
        if (config instanceof AbstractCloudConfiguration) {
            for (DBWNetworkProfile profile : ((AbstractCloudConfiguration)config).getTunnelProfiles()) {
                try {
                    profile.resolveSecrets(DBSSecretController.getGlobalSecretController());
                }
                catch (DBException e) {
                    log.error((Object)("Error resolving profile '" + profile.getProfileId() + "' secrets"), (Throwable)e);
                }
            }
        }
        if (this.saPage != null) {
            this.saPage.initialize((CPCloudConfiguration<?>)config);
        }
    }

    protected boolean isDefaultConfigurationEditable() {
        return false;
    }

    public void saveSettings(@NotNull CONFIG config) {
        if (this.networkProfilesPage != null && this.networkProfilesPage.getControl() != null) {
            this.networkProfilesPage.performOk();
        }
        if (this.saPage != null && this.saPage.getControl() != null) {
            this.saPage.performApply();
        }
    }
}

