/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.ui.navigator.fs;

import com.dbeaver.cloud.internal.CloudUIMessages;
import com.dbeaver.cloud.model.navigator.CPCloudRegionProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationListener;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerRefresh;
import org.jkiss.dbeaver.ui.navigator.project.FileSystemExplorerView;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class CloudFileSystemExplorerView
extends FileSystemExplorerView
implements CPCloudConfigurationListener {
    private static final String VIEW_ID = "com.dbeaver.cloud.fsExplorerView";
    private static final Log log = Log.getLog(CloudFileSystemExplorerView.class);
    private final Set<CPCloudRegionProvider> loadingRegions = Collections.synchronizedSet(new HashSet());

    public CloudFileSystemExplorerView() {
        CPCloudConfigurationRegistry.getInstance().addConfigurationChangeListener((CPCloudConfigurationListener)this, false);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.handleCloudConfigurationChange();
    }

    public void handleCloudConfigurationChange() {
        DBNFileSystems fsRootNode;
        DBNProject projectNode = CloudFileSystemExplorerView.getGlobalNavigatorModel().getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        if (projectNode != null && (fsRootNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class)) != null) {
            new AbstractJob("Refresh file systems"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        DBNFileSystem[] children = fsRootNode.getChildren(monitor);
                        if (children != null) {
                            NavigatorHandlerRefresh.refreshNavigator(List.of(children));
                        }
                        fsRootNode.refreshNode(monitor, (Object)this);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public void dispose() {
        CPCloudConfigurationRegistry.getInstance().removeConfigurationChangeListener((CPCloudConfigurationListener)this);
        super.dispose();
    }

    protected void createExtraColumns(ViewerColumnController<?, ?> columnController, final TreeViewer viewer) {
        columnController.addColumn(CloudUIMessages.cloud_file_explorer_columns_region_text, CloudUIMessages.cloud_file_explorer_columns_region_tip, 131072, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(final Object element) {
                DBFVirtualFileSystemRoot root;
                if (element instanceof DBNFileSystemRoot && (root = ((DBNFileSystemRoot)element).getRoot()) instanceof CPCloudRegionProvider) {
                    try {
                        final CPCloudRegionProvider provider = (CPCloudRegionProvider)root;
                        String region = provider.getCloudRegion(null);
                        if (region != null) {
                            return region;
                        }
                        if (CloudFileSystemExplorerView.this.loadingRegions.add(provider)) {
                            AbstractJob job = new AbstractJob("Load cloud region name"){

                                protected IStatus run(DBRProgressMonitor monitor) {
                                    try {
                                        provider.getCloudRegion(monitor);
                                        return Status.OK_STATUS;
                                    }
                                    catch (DBException e) {
                                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                                    }
                                }
                            };
                            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                public void done(IJobChangeEvent event) {
                                    (this).CloudFileSystemExplorerView.this.loadingRegions.remove(provider);
                                    UIUtils.asyncExec(() -> viewer.refresh(element));
                                }
                            });
                            job.setUser(false);
                            job.setSystem(true);
                            job.schedule();
                        }
                    }
                    catch (DBException e) {
                        log.warn((Object)"Error loading cloud region", (Throwable)e);
                    }
                    return "...";
                }
                return "";
            }
        });
    }
}

