/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.ollama.dto;

import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatMessage;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatOptions;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaRole;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.ai.AIMessage;

public record OllamaChatRequest(String model, List<OllamaChatMessage> messages, boolean stream, OllamaChatOptions options) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private List<OllamaChatMessage> messages = new ArrayList<OllamaChatMessage>();
        private boolean stream = false;
        private OllamaChatOptions options;

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder addMessage(AIMessage daiMessage) {
            this.messages.add(new OllamaChatMessage(OllamaRole.from(daiMessage.getRole()), daiMessage.getContent()));
            return this;
        }

        public Builder addMessages(List<AIMessage> messageList) {
            for (AIMessage daiMessage : messageList) {
                this.addMessage(daiMessage);
            }
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder options(double temperature, int contextSize) {
            this.options = new OllamaChatOptions(temperature, contextSize);
            return this;
        }

        public OllamaChatRequest build() {
            if (this.model == null || this.options == null) {
                throw new IllegalStateException("Model and Options must be provided");
            }
            return new OllamaChatRequest(this.model, this.messages, this.stream, this.options);
        }
    }
}

