/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.ai.engine.ollama;

import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatChunk;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatRequest;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaChatResponse;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaModel;
import com.dbeaver.model.ai.engine.ollama.dto.OllamaModels;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseConsumer;
import org.jkiss.dbeaver.model.ai.engine.AbstractHttpAIClient;
import org.jkiss.dbeaver.model.ai.utils.AIHttpUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class OllamaClient
extends AbstractHttpAIClient {
    private static final Log log = Log.getLog(OllamaClient.class);
    private static final Duration TIMEOUT = Duration.ofSeconds(30L);
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    private final String baseUrl;

    public OllamaClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public List<OllamaModel> loadModels(@NotNull DBRProgressMonitor monitor) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().header("Content-type", "application/json").uri(AIHttpUtils.resolve((String)this.baseUrl, (String[])new String[]{"/api/tags"})).GET().timeout(TIMEOUT).build();
        return ((OllamaModels)GSON.fromJson(this.client.send(monitor, request), OllamaModels.class)).models();
    }

    public OllamaChatResponse chat(DBRProgressMonitor monitor, OllamaChatRequest chatRequest) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().header("Content-type", "application/json").uri(AIHttpUtils.resolve((String)this.baseUrl, (String[])new String[]{"/api/chat"})).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)chatRequest))).timeout(TIMEOUT).build();
        return (OllamaChatResponse)GSON.fromJson(this.client.send(monitor, request), OllamaChatResponse.class);
    }

    @NotNull
    protected DBException mapHttpError(int statusCode, @NotNull String body) {
        log.debug((Object)("Ollama request failed: " + statusCode + ", " + body));
        return new DBException("Ollama request failed: " + AIHttpUtils.parseOpenAIStyleErrorMessage((String)body));
    }

    public void createChatCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull OllamaChatRequest completionRequest, @NotNull AIEngineResponseConsumer listener) throws DBException {
        HttpRequest request = HttpRequest.newBuilder().header("Content-type", "application/json").uri(AIHttpUtils.resolve((String)this.baseUrl, (String[])new String[]{"/api/chat"})).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)completionRequest))).timeout(TIMEOUT).build();
        this.client.sendAsync(request, line -> {
            try {
                OllamaChatChunk chunk = (OllamaChatChunk)GSON.fromJson(line, OllamaChatChunk.class);
                if (chunk.done()) {
                    listener.close();
                } else {
                    listener.nextChunk(new AIEngineResponseChunk(List.of(chunk.message().content())));
                }
            }
            catch (Exception e) {
                listener.error((Throwable)e);
            }
        }, arg_0 -> ((AIEngineResponseConsumer)listener).error(arg_0), () -> ((AIEngineResponseConsumer)listener).close());
    }
}

