/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static final String Emtpy = "";
    private static final String UTF8_CHARSET = StandardCharsets.UTF_8.name();

    public static boolean isNullOrWhiteSpace(String str) {
        return StringUtils.isEmpty(str) || StringUtils.isWhitespace(str);
    }

    public static boolean isNullOrEmpty(String str) {
        return StringUtils.isEmpty(str);
    }

    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static boolean areEqual(String str1, String str2) {
        return StringUtils.equals(str1, str2);
    }

    public static boolean areEqualIgnoreCase(String str1, String str2) {
        return StringUtils.equalsIgnoreCase(str1, str2);
    }

    public static boolean containsIgnoreCase(String str1, String str2) {
        return StringUtils.containsIgnoreCase(str1, str2);
    }

    public static String fromCamelCaseToUpperCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str);
        int i = 1;
        while (i < result.length()) {
            if (Character.isUpperCase(result.charAt(i))) {
                result.insert(i, '_');
                i += 2;
                continue;
            }
            result.replace(i, i + 1, Character.toString(Character.toUpperCase(result.charAt(i))));
            ++i;
        }
        return result.toString();
    }

    public static String encodeURIComponent(String text) {
        String result;
        try {
            result = URLEncoder.encode(text, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int len = result.length();
        StringBuilder buf = new StringBuilder(result.length() + 4);
        for (int i = 0; i < len; ++i) {
            char currentChar = result.charAt(i);
            if (currentChar == '+') {
                buf.append("%20");
                continue;
            }
            if (currentChar == '%' && i < len - 2) {
                char nextChar = result.charAt(i + 1);
                char secondToNextChar = result.charAt(i + 2);
                if (nextChar == '7' && secondToNextChar == 'E') {
                    i += 2;
                    buf.append('~');
                    continue;
                }
                if (nextChar == '2') {
                    switch (secondToNextChar) {
                        case '1': {
                            buf.append('!');
                            i += 2;
                            break;
                        }
                        case '7': {
                            buf.append('\'');
                            i += 2;
                            break;
                        }
                        case '8': {
                            buf.append('(');
                            i += 2;
                            break;
                        }
                        case '9': {
                            buf.append(')');
                            i += 2;
                            break;
                        }
                        default: {
                            buf.append(currentChar);
                            break;
                        }
                    }
                    continue;
                }
                buf.append(currentChar);
                continue;
            }
            buf.append(currentChar);
        }
        return buf.toString();
    }
}

