/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetColumnRemarksGenerator;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class SetColumnRemarksGeneratorDatabricks
extends SetColumnRemarksGenerator {
    public boolean supports(SetColumnRemarksStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(SetColumnRemarksStatement setColumnRemarksStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)setColumnRemarksStatement.getTableName());
        validationErrors.checkRequiredField("columnName", (Object)setColumnRemarksStatement.getColumnName());
        validationErrors.checkDisallowedField("catalogName", (Object)setColumnRemarksStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        if (database instanceof MySQLDatabase) {
            validationErrors.checkRequiredField("columnDataType", (Object)StringUtils.trimToNull((String)setColumnRemarksStatement.getColumnDataType()));
        }
        return validationErrors;
    }

    public Warnings warn(SetColumnRemarksStatement statementType, Database database, SqlGeneratorChain<SetColumnRemarksStatement> sqlGeneratorChain) {
        Warnings warnings = super.warn(statementType, database, sqlGeneratorChain);
        if (database instanceof MySQLDatabase) {
            ((MySQLDatabase)database).warnAboutAlterColumn("setColumnRemarks", warnings);
        }
        return warnings;
    }

    public Sql[] generateSql(SetColumnRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String remarksEscaped = database.escapeStringForDatabase(StringUtils.trimToEmpty((String)statement.getRemarks()));
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " COMMENT '" + remarksEscaped + "'", new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

