/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import java.util.Date;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGenerator;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.structure.DatabaseObject;

public class InsertOrUpdateGeneratorDatabricks
extends InsertOrUpdateGenerator {
    public boolean supports(InsertOrUpdateStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    protected String getInsertStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            columns.append(",");
            columns.append(columnKey);
            values.append(",");
            values.append(this.convertToString(insertOrUpdateStatement.getColumnValue(columnKey), database));
        }
        columns.deleteCharAt(0);
        values.deleteCharAt(0);
        return "INSERT (" + columns + ") VALUES (" + values + ")";
    }

    protected String getUpdateStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder("UPDATE SET ");
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            if (!insertOrUpdateStatement.getAllowColumnUpdate(columnKey) || whereClause.contains(columnKey)) continue;
            sql.append("target.").append(columnKey).append(" = ");
            sql.append(this.convertToString(insertOrUpdateStatement.getColumnValue(columnKey), database));
            sql.append(",");
        }
        int lastComma = sql.lastIndexOf(",");
        if (lastComma > -1) {
            sql.deleteCharAt(lastComma);
        }
        return sql.toString();
    }

    protected String getRecordCheck(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause) {
        return "MERGE INTO " + insertOrUpdateStatement.getTableName() + " AS target USING (SELECT 1) AS source ON target." + whereClause + " WHEN MATCHED THEN ";
    }

    protected String getElse(Database database) {
        return " WHEN NOT MATCHED THEN ";
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null || "".equals(newValue.toString()) || "NULL".equalsIgnoreCase(newValue.toString()) ? "NULL" : (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, database) ? "'" + database.escapeStringForDatabase(newValue.toString()) + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (Boolean.TRUE.equals(newValue) ? DataTypeFactory.getInstance().getTrueBooleanValue(database) : DataTypeFactory.getInstance().getFalseBooleanValue(database)) : newValue.toString())));
        return sqlString;
    }

    public Sql[] generateSql(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder completeSql = new StringBuilder();
        String whereClause = this.getWhereClause(insertOrUpdateStatement, database);
        completeSql.append(this.getRecordCheck(insertOrUpdateStatement, database, whereClause));
        String updateStatement = this.getUpdateStatement(insertOrUpdateStatement, database, whereClause, sqlGeneratorChain);
        completeSql.append(updateStatement);
        if (Boolean.FALSE.equals(insertOrUpdateStatement.getOnlyUpdate())) {
            completeSql.append(this.getElse(database));
            completeSql.append(this.getInsertStatement(insertOrUpdateStatement, database, sqlGeneratorChain));
            completeSql.append(this.getPostUpdateStatements(database));
        }
        return new Sql[]{new UnparsedSql(completeSql.toString(), "", new DatabaseObject[]{this.getAffectedTable(insertOrUpdateStatement)})};
    }
}

