/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddPrimaryKeyGenerator;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;

public class AddPrimaryKeyGeneratorDatabricks
extends AddPrimaryKeyGenerator {
    public boolean supports(AddPrimaryKeyStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(AddPrimaryKeyStatement addPrimaryKeyStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("columnNames", (Object)addPrimaryKeyStatement.getColumnNames());
        validationErrors.checkRequiredField("tableName", (Object)addPrimaryKeyStatement.getTableName());
        if (Boolean.TRUE.equals(addPrimaryKeyStatement.isClustered())) {
            validationErrors.addError("Cannot specify clustered=true on " + database.getShortName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(AddPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(statement.getConstraintName()) + " PRIMARY KEY";
        sql = sql + " (" + database.escapeColumnNameList(statement.getColumnNames()) + ")";
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedPrimaryKey(statement)})};
    }
}

