/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.sqlgenerator;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddForeignKeyConstraintGenerator;
import liquibase.statement.core.AddForeignKeyConstraintStatement;
import liquibase.structure.DatabaseObject;

public class AddForeignKeyConstraintGeneratorDatabricks
extends AddForeignKeyConstraintGenerator {
    public boolean supports(AddForeignKeyConstraintStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(AddForeignKeyConstraintStatement addForeignKeyConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        if ((addForeignKeyConstraintStatement.isInitiallyDeferred() || addForeignKeyConstraintStatement.isDeferrable()) && !database.supportsInitiallyDeferrableColumns()) {
            validationErrors.checkDisallowedField("initiallyDeferred", (Object)addForeignKeyConstraintStatement.isInitiallyDeferred(), database, new Class[0]);
            validationErrors.checkDisallowedField("deferrable", (Object)addForeignKeyConstraintStatement.isDeferrable(), database, new Class[0]);
        }
        validationErrors.checkRequiredField("baseColumnNames", (Object)addForeignKeyConstraintStatement.getBaseColumnNames());
        validationErrors.checkRequiredField("baseTableNames", (Object)addForeignKeyConstraintStatement.getBaseTableName());
        validationErrors.checkRequiredField("referencedColumnNames", (Object)addForeignKeyConstraintStatement.getReferencedColumnNames());
        validationErrors.checkRequiredField("referencedTableName", (Object)addForeignKeyConstraintStatement.getReferencedTableName());
        validationErrors.checkRequiredField("constraintName", (Object)addForeignKeyConstraintStatement.getConstraintName());
        validationErrors.checkDisallowedField("onDelete", (Object)addForeignKeyConstraintStatement.getOnDelete(), database, new Class[]{SybaseDatabase.class});
        if (database instanceof SybaseASADatabase) {
            validationErrors.addWarning("SQL Anywhere will apply RESTRICT instead of NO ACTION.");
        }
        return validationErrors;
    }

    public Sql[] generateSql(AddForeignKeyConstraintStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(database.escapeTableName(statement.getBaseTableCatalogName(), statement.getBaseTableSchemaName(), statement.getBaseTableName())).append(" ADD CONSTRAINT ");
        if (!(database instanceof InformixDatabase)) {
            sb.append(database.escapeConstraintName(statement.getConstraintName()));
        }
        sb.append(" FOREIGN KEY (").append(database.escapeColumnNameList(statement.getBaseColumnNames())).append(") REFERENCES ").append(database.escapeTableName(statement.getReferencedTableCatalogName(), statement.getReferencedTableSchemaName(), statement.getReferencedTableName())).append(" (").append(database.escapeColumnNameList(statement.getReferencedColumnNames())).append(")");
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[]{this.getAffectedForeignKey(statement)})};
    }
}

