/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.snapshot.jvm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.snapshot.jvm.SchemaSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.JdbcUtil;

public class SchemaSnapshotGeneratorDatabricks
extends SchemaSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof DatabricksDatabase) {
            return super.getPriority(objectType, database) + 5;
        }
        return -1;
    }

    protected String[] getDatabaseSchemaNames(Database database) throws SQLException, DatabaseException {
        ArrayList<String> returnList = new ArrayList<String>();
        try (ResultSet schemas = ((JdbcConnection)database.getConnection()).getMetaData().getSchemas(database.getDefaultCatalogName(), null);){
            while (schemas.next()) {
                returnList.add(JdbcUtil.getValueForColumn((ResultSet)schemas, (String)"TABLE_SCHEM", (Database)database));
            }
        }
        return returnList.toArray(new String[0]);
    }
}

