/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.snapshot.jvm;

import java.sql.SQLException;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.databricks.snapshot.jvm.ResultSetCacheDatabricks;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.core.Schema;

public class ResultSetConstraintsExtractorDatabricks
extends ResultSetCacheDatabricks.SingleResultSetExtractor {
    private final Database database;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    public ResultSetConstraintsExtractorDatabricks(DatabaseSnapshot databaseSnapshot, String catalogName, String schemaName, String tableName) {
        super(databaseSnapshot.getDatabase());
        this.database = databaseSnapshot.getDatabase();
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public boolean bulkContainsSchema(String schemaKey) {
        return false;
    }

    public ResultSetCacheDatabricks.RowData rowKeyParameters(CachedRow row) {
        return new ResultSetCacheDatabricks.RowData(this.catalogName, this.schemaName, this.database, row.getString("TABLE_NAME"));
    }

    public ResultSetCacheDatabricks.RowData wantedKeyParameters() {
        return new ResultSetCacheDatabricks.RowData(this.catalogName, this.schemaName, this.database, this.tableName);
    }

    public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.catalogName, this.schemaName).customize(this.database);
        return this.executeAndExtract(this.database, this.createSql(((AbstractJdbcDatabase)this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), this.tableName), new Object[0]);
    }

    public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.catalogName, this.schemaName).customize(this.database);
        return this.executeAndExtract(this.database, this.createSql(((AbstractJdbcDatabase)this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), null), new Object[0]);
    }

    private String createSql(String catalog, String schema, String table) {
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalog, schema).customize(this.database);
        String jdbcSchemaName = this.database.correctObjectName(((AbstractJdbcDatabase)this.database).getJdbcSchemaName(catalogAndSchema), Schema.class);
        String sql = "SELECT CONSTRAINT_NAME, CONSTRAINT_TYPE, TABLE_NAME FROM " + this.database.getSystemSchema() + ".TABLE_CONSTRAINTS  WHERE TABLE_SCHEMA='" + jdbcSchemaName + "' AND CONSTRAINT_TYPE='UNIQUE'";
        if (table != null) {
            sql = sql + " AND TABLE_NAME='" + table + "'";
        }
        return sql;
    }
}

