/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.analyzeTable;

import java.util.Map;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.databricks.change.analyzeTable.AnalyzeTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class AnalyzeTableGenerator
extends AbstractSqlGenerator<AnalyzeTableStatement> {
    public boolean supports(AnalyzeTableStatement statement, Database database) {
        return database instanceof DatabricksDatabase;
    }

    public ValidationErrors validate(AnalyzeTableStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        return validationErrors;
    }

    public Sql[] generateSql(AnalyzeTableStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("ANALYZE TABLE ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        if (!statement.getPartition().isEmpty()) {
            Map.Entry<String, String> partitionMap = statement.getPartition().entrySet().iterator().next();
            String partitionColumnName = partitionMap.getKey();
            String partitionColumnValue = partitionMap.getValue();
            sql.append(" PARTITION (").append(partitionColumnName).append(" = '").append(partitionColumnValue).append("') ");
        }
        if (!statement.getAnalyzeColumns().isEmpty()) {
            sql.append("COMPUTE STATISTICS FOR COLUMNS  (").append(String.join((CharSequence)", ", statement.getAnalyzeColumns())).append(")");
        } else {
            sql.append(" COMPUTE STATISTICS");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

