/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.analyzeTable;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.databricks.change.analyzeTable.AnalyzeTableStatement;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="analyzeTable", description="Analyze Table Stats", priority=5)
public class AnalyzeTableChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private Map<String, String> partition = Collections.emptyMap();
    private List<String> analyzeColumns = new ArrayList<String>();

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully analyzed.", this.getCatalogName(), this.getSchemaName(), this.getTableName());
    }

    protected Change[] createInverses() {
        return new Change[0];
    }

    public SqlStatement[] generateStatements(Database database) {
        AnalyzeTableStatement statement = new AnalyzeTableStatement();
        statement.setCatalogName(this.getCatalogName());
        statement.setSchemaName(this.getSchemaName());
        statement.setTableName(this.getTableName());
        if (this.getPartition() == null) {
            statement.setPartition(Collections.emptyMap());
        } else {
            statement.setPartition(this.getPartition());
        }
        if (this.getAnalyzeColumns() == null) {
            ArrayList<String> noColsArray = new ArrayList<String>();
            statement.setAnalyzeColumns(noColsArray);
        } else {
            statement.setAnalyzeColumns(this.getAnalyzeColumns());
        }
        return new SqlStatement[]{statement};
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public Map<String, String> getPartition() {
        return this.partition;
    }

    @Generated
    public List<String> getAnalyzeColumns() {
        return this.analyzeColumns;
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setPartition(Map<String, String> partition) {
        this.partition = partition;
    }

    @Generated
    public void setAnalyzeColumns(List<String> analyzeColumns) {
        this.analyzeColumns = analyzeColumns;
    }
}

