/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.databricks.change.addCheckConstraint;

import java.text.MessageFormat;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.ext.databricks.change.addCheckConstraint.AddCheckConstraintStatementDatabricks;
import liquibase.ext.databricks.change.dropCheckConstraint.DropCheckConstraintChangeDatabricks;
import liquibase.ext.databricks.database.DatabricksDatabase;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="addCheckConstraint", description="Adds check constraint to Delta Table", priority=5, appliesTo={"column"})
public class AddCheckConstraintChangeDatabricks
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String constraintBody;

    public boolean supports(Database database) {
        return database instanceof DatabricksDatabase;
    }

    @DatabaseChangeProperty(description="Name of the check constraint")
    public String getConstraintName() {
        return this.constraintName;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getConstraintBody() {
        return this.constraintBody;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("{0}.{1}.{2} successfully Added check constraint {3}.", this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName());
    }

    protected Change[] createInverses() {
        DropCheckConstraintChangeDatabricks inverse = new DropCheckConstraintChangeDatabricks();
        inverse.setTableName(this.getTableName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setCatalogName(this.getCatalogName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public SqlStatement[] generateStatements(Database database) {
        AddCheckConstraintStatementDatabricks statement = new AddCheckConstraintStatementDatabricks();
        statement.setCatalogName(this.getCatalogName());
        statement.setSchemaName(this.getSchemaName());
        statement.setTableName(this.getTableName());
        statement.setConstraintName(this.getConstraintName());
        statement.setConstraintBody(this.getConstraintBody());
        return new SqlStatement[]{statement};
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @Generated
    public void setConstraintBody(String constraintBody) {
        this.constraintBody = constraintBody;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }
}

