/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.security.vault;

import com.dbeaver.model.vault.VaultParametersProviderConfiguration;
import com.dbeaver.ui.internal.UICoreMessages;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class VaultParametersProviderConfigurator
implements IObjectPropertyConfigurator<VaultParametersProviderConfiguration, VaultParametersProviderConfiguration> {
    private static final int PORT_MAX_VALUE = 65535;
    private static final int PORT_MIN_VALUE = 0;
    private Combo authType;
    private Text serverUrl;
    private Text tokenText;
    private Button isGlobal;
    private Text jwtText;
    private Text jwtRoleText;
    private Text oauthAuthURLText;
    private Text oauthTokenURLText;
    private Text oauthClientIdText;
    private Text oauthClientSecretText;
    private Text oauthCallbackURLText;
    private Spinner oauthCallbackPortText;
    private Text usernameText;
    private Text passwordText;
    private Group tokenGroup;
    private Group passwordGroup;
    private Group jwtGroup;
    private Group oauthGroup;

    public void createControl(final @NotNull Composite parent, VaultParametersProviderConfiguration object, @NotNull Runnable propertyChangeListener) {
        GridData gd = new GridData(768);
        gd.widthHint = 50 * UIUtils.getFontHeight((Control)parent);
        this.serverUrl = UIUtils.createLabelText((Composite)parent, (String)UICoreMessages.vault_server_url_label, (String)CommonUtils.notEmpty((String)object.getVaultUrl()), (int)2048, (Object)gd);
        UIUtils.createControlLabel((Composite)parent, (String)UICoreMessages.vault_auth_type_label);
        Composite authTypeGroup = UIUtils.createComposite((Composite)parent, (int)2);
        this.authType = new Combo(authTypeGroup, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.authType.setLayoutData((Object)gd);
        VaultParametersProviderConfiguration.AuthType[] authTypeArray = VaultParametersProviderConfiguration.AuthType.values();
        int n = authTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VaultParametersProviderConfiguration.AuthType type = authTypeArray[n2];
            if (type.canShow()) {
                this.authType.add(type.getName());
            }
            ++n2;
        }
        this.authType.select(0);
        this.authType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VaultParametersProviderConfigurator.this.updateVisibilityOfForm(parent);
            }
        });
        this.tokenGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.vault_token_group_label, (int)2, (int)802, (int)300);
        ((GridData)this.tokenGroup.getLayoutData()).horizontalSpan = 2;
        this.tokenText = UIUtils.createLabelText((Composite)this.tokenGroup, (String)UICoreMessages.vault_token_label, null, (int)0x400800);
        this.jwtGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.vault_jwt_group_label, (int)2, (int)802, (int)300);
        ((GridData)this.jwtGroup.getLayoutData()).horizontalSpan = 2;
        this.jwtText = UIUtils.createLabelText((Composite)this.jwtGroup, (String)UICoreMessages.vault_jwt_provider_label, null, (int)2048);
        this.jwtText.setToolTipText(UICoreMessages.vault_jwt_provider_tooltip);
        this.jwtRoleText = UIUtils.createLabelText((Composite)this.jwtGroup, (String)UICoreMessages.vault_jwt_role_label, null, (int)2048);
        this.jwtRoleText.setToolTipText(UICoreMessages.vault_jwt_role_tooltip);
        this.oauthGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.vault_oauth_group_label, (int)2, (int)802, (int)300);
        ((GridData)this.oauthGroup.getLayoutData()).horizontalSpan = 2;
        this.oauthAuthURLText = UIUtils.createLabelText((Composite)this.oauthGroup, (String)UICoreMessages.vault_oauth_auth_url_label, null, (int)2048);
        this.oauthTokenURLText = UIUtils.createLabelText((Composite)this.oauthGroup, (String)UICoreMessages.vault_oauth_token_url_label, null, (int)2048);
        UIUtils.createControlLabel((Composite)this.oauthGroup, (String)UICoreMessages.vault_oauth_callback_port_label);
        Composite callbackGroup = (Composite)((CompositeFactory)((CompositeFactory)CompositeFactory.newComposite((int)0).layout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create())).layoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create())).create((Widget)this.oauthGroup);
        this.oauthCallbackPortText = UIUtils.createSpinner((Composite)callbackGroup, null, (int)0, (int)0, (int)65535);
        this.oauthCallbackPortText.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.oauthCallbackURLText.setText(String.format("http://localhost:%s%s", this.oauthCallbackPortText.getSelection(), "/callback"))));
        this.oauthCallbackURLText = UIUtils.createLabelText((Composite)callbackGroup, (String)UICoreMessages.vault_oauth_callback_url_label, null, (int)2048);
        this.oauthCallbackURLText.setEditable(false);
        this.oauthClientIdText = UIUtils.createLabelText((Composite)this.oauthGroup, (String)UICoreMessages.vault_oauth_client_id_label, null, (int)2048);
        this.oauthClientSecretText = UIUtils.createLabelText((Composite)this.oauthGroup, (String)UICoreMessages.vault_oauth_client_secret_label, null, (int)0x400800);
        this.passwordGroup = UIUtils.createControlGroup((Composite)parent, (String)UICoreMessages.vault_password_group_label, (int)2, (int)802, (int)300);
        ((GridData)this.passwordGroup.getLayoutData()).horizontalSpan = 2;
        this.usernameText = UIUtils.createLabelText((Composite)this.passwordGroup, (String)UICoreMessages.vault_username_label, null, (int)2048);
        this.passwordText = UIUtils.createLabelText((Composite)this.passwordGroup, (String)UICoreMessages.vault_password_label, null, (int)0x400800);
        if (DBWorkbench.getPlatform().getApplication().isDistributed()) {
            this.isGlobal = UIUtils.createCheckbox((Composite)parent, (String)"Global Configuration", (boolean)object.isGlobalConfiguration());
        }
        this.updateVisibilityOfForm(parent);
    }

    private void updateVisibilityOfForm(@NotNull Composite parent) {
        VaultParametersProviderConfiguration.AuthType selectedAuthType = this.getSelectedAuthType();
        UIUtils.setControlVisible((Control)this.tokenGroup, (VaultParametersProviderConfiguration.AuthType.TOKEN == selectedAuthType ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.passwordGroup, (VaultParametersProviderConfiguration.AuthType.USERNAME_PASSWORD == selectedAuthType ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.jwtGroup, (VaultParametersProviderConfiguration.AuthType.JWT == selectedAuthType || VaultParametersProviderConfiguration.AuthType.OAUTH2 == selectedAuthType ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.oauthGroup, (VaultParametersProviderConfiguration.AuthType.OAUTH2 == selectedAuthType ? 1 : 0) != 0);
        parent.layout(true, true);
        UIUtils.resizeShell((Shell)parent.getShell());
    }

    public void loadSettings(@NotNull VaultParametersProviderConfiguration vaultParametersProviderConfiguration) {
        this.serverUrl.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getVaultUrl()));
        this.tokenText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getToken()));
        if (this.isGlobal != null) {
            this.isGlobal.setSelection(vaultParametersProviderConfiguration.isGlobalConfiguration());
        }
        this.usernameText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getUsername()));
        this.passwordText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getPassword()));
        this.jwtText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getVaultJwtProviderId()));
        this.jwtRoleText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getVaultRoleClaim()));
        this.oauthAuthURLText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getSsoAuthEndpointURL()));
        this.oauthTokenURLText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getSsoTokenEndpointURL()));
        this.oauthClientSecretText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getSsoClientSecret()));
        this.oauthClientIdText.setText(CommonUtils.notEmpty((String)vaultParametersProviderConfiguration.getSsoClientId()));
        this.oauthCallbackPortText.setSelection(vaultParametersProviderConfiguration.getSsoCallbackPort());
        this.oauthCallbackPortText.notifyListeners(13, new Event());
        this.authType.select(Arrays.asList(this.authType.getItems()).indexOf(vaultParametersProviderConfiguration.getAuthType().getName()));
        this.updateVisibilityOfForm((Composite)this.authType);
    }

    public void saveSettings(@NotNull VaultParametersProviderConfiguration vaultParametersProviderConfiguration) {
        VaultParametersProviderConfiguration.AuthType selectedAuthType;
        vaultParametersProviderConfiguration.setVaultUrl(this.serverUrl.getText());
        vaultParametersProviderConfiguration.setToken(this.tokenText.getText());
        if (this.isGlobal != null) {
            vaultParametersProviderConfiguration.setGlobalConfiguration(this.isGlobal.getSelection());
        }
        if ((selectedAuthType = this.getSelectedAuthType()) == null) {
            return;
        }
        switch (selectedAuthType) {
            case TOKEN: {
                vaultParametersProviderConfiguration.setAuthType(VaultParametersProviderConfiguration.AuthType.TOKEN);
                vaultParametersProviderConfiguration.setToken(this.tokenText.getText());
                break;
            }
            case JWT: {
                vaultParametersProviderConfiguration.setAuthType(VaultParametersProviderConfiguration.AuthType.JWT);
                vaultParametersProviderConfiguration.setVaultJwtProviderId(this.jwtText.getText());
                vaultParametersProviderConfiguration.setVaultRoleClaim(this.jwtRoleText.getText());
                break;
            }
            case USERNAME_PASSWORD: {
                vaultParametersProviderConfiguration.setAuthType(VaultParametersProviderConfiguration.AuthType.USERNAME_PASSWORD);
                vaultParametersProviderConfiguration.setUsername(this.usernameText.getText());
                vaultParametersProviderConfiguration.setPassword(this.passwordText.getText());
                break;
            }
            case OAUTH2: {
                vaultParametersProviderConfiguration.setAuthType(VaultParametersProviderConfiguration.AuthType.OAUTH2);
                vaultParametersProviderConfiguration.setVaultJwtProviderId(this.jwtText.getText());
                vaultParametersProviderConfiguration.setVaultRoleClaim(this.jwtRoleText.getText());
                vaultParametersProviderConfiguration.setSsoAuthEndpointURL(this.oauthAuthURLText.getText());
                vaultParametersProviderConfiguration.setSsoTokenEndpointURL(this.oauthTokenURLText.getText());
                vaultParametersProviderConfiguration.setSsoClientId(this.oauthClientIdText.getText());
                vaultParametersProviderConfiguration.setSsoClientSecret(this.oauthClientSecretText.getText());
                vaultParametersProviderConfiguration.setSsoCallbackPort(this.oauthCallbackPortText.getSelection());
            }
        }
    }

    public void resetSettings(@NotNull VaultParametersProviderConfiguration vaultParametersProviderConfiguration) {
    }

    @Nullable
    private VaultParametersProviderConfiguration.AuthType getSelectedAuthType() {
        String selectedAuthType = this.authType.getItems()[this.authType.getSelectionIndex()];
        VaultParametersProviderConfiguration.AuthType[] authTypeArray = VaultParametersProviderConfiguration.AuthType.values();
        int n = authTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VaultParametersProviderConfiguration.AuthType type = authTypeArray[n2];
            if (Objects.equals(selectedAuthType, type.getName())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public boolean isComplete() {
        VaultParametersProviderConfiguration.AuthType selectedAuthType = this.getSelectedAuthType();
        if (selectedAuthType == null) {
            return false;
        }
        if (CommonUtils.isNotEmpty((String)this.serverUrl.getText())) {
            if (switch (selectedAuthType) {
                case VaultParametersProviderConfiguration.AuthType.JWT -> CommonUtils.isNotEmpty((String)this.jwtText.getText());
                case VaultParametersProviderConfiguration.AuthType.OAUTH2 -> {
                    if (CommonUtils.isNotEmpty((String)this.oauthAuthURLText.getText()) && CommonUtils.isNotEmpty((String)this.jwtText.getText()) && CommonUtils.isNotEmpty((String)this.oauthClientIdText.getText()) && CommonUtils.isNotEmpty((String)this.oauthTokenURLText.getText())) {
                        yield true;
                    }
                    yield false;
                }
                case VaultParametersProviderConfiguration.AuthType.TOKEN -> CommonUtils.isNotEmpty((String)this.tokenText.getText());
                case VaultParametersProviderConfiguration.AuthType.USERNAME_PASSWORD -> {
                    if (CommonUtils.isNotEmpty((String)this.usernameText.getText()) && CommonUtils.isNotEmpty((String)this.passwordText.getText())) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new MatchException(null, null);
            }) {
                return true;
            }
        }
        return false;
    }
}

