/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.firestore.model;

import com.dbeaver.db.google.firestore.FirestoreUtils;
import com.dbeaver.db.google.firestore.data.FireStoreDocument;
import com.dbeaver.db.google.firestore.data.FireStoreResultSet;
import com.dbeaver.db.google.firestore.exec.FireStoreDatabaseStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreExecutionContext;
import com.dbeaver.db.google.firestore.exec.FireStoreInsertStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreRemoveStatement;
import com.dbeaver.db.google.firestore.exec.FireStoreSession;
import com.dbeaver.db.google.firestore.exec.FireStoreUpdateStatement;
import com.dbeaver.db.google.firestore.model.FireStoreDatasource;
import com.dbeaver.model.document.DBAbstractDocumentContainer;
import com.dbeaver.model.document.data.DBCCollectionHierarchical;
import com.google.cloud.firestore.AggregateQuerySnapshot;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.QuerySnapshot;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDocumentLocator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class FireStoreCollection
extends DBAbstractDocumentContainer<FireStoreDatasource>
implements DBSDataContainer,
DBSEntity,
DBSDataManipulator,
DBPQualifiedObject,
DBPSaveableObject,
DBSDocumentLocator,
DBCCollectionHierarchical {
    public static final int TIMEOUT = 30;
    private String id;
    private String path;
    private boolean persisted;

    public FireStoreCollection(FireStoreDatasource datasource, String id, String path, boolean persisted) {
        super((DBPDataSource)datasource);
        this.id = id;
        this.path = path;
        this.persisted = persisted;
    }

    @Property(viewable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.id;
    }

    @Property(viewable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=2)
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getDescription() {
        return "";
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.count", "data.filter", "data.select", "data.insert", "data.update", "data.delete"};
    }

    public void setName(String name) {
        this.id = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        DBCStatistics statistics = new DBCStatistics();
        System.currentTimeMillis();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.beginTask("Read collection documents", 1);
        monitor.subTask("Query collection '" + this.getName() + "' documents");
        try {
            try {
                Throwable throwable = null;
                Object var15_14 = null;
                try (FireStoreDatabaseStatement statement = new FireStoreDatabaseStatement((FireStoreSession)session, this, firstRow, maxRows, dataFilter);){
                    FireStoreResultSet resultSet;
                    statement.setResultsFetchSize(fetchSize);
                    statement.setLimit(firstRow, maxRows);
                    statistics.addStatementsCount();
                    statistics.setQueryText(statement.getQueryString());
                    if (statement.executeStatement() && (resultSet = statement.openResultSet()) != null) {
                        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)firstRow, (long)maxRows);
                        DBDDataReceiver.fetchRowsWithStatistics((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (DBCStatistics)statistics);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                throw new DBCException(e, session.getExecutionContext());
            }
        }
        finally {
            dataReceiver.close();
        }
        return statistics;
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        try {
            return ((AggregateQuerySnapshot)((FireStoreSession)session).getExecutionContext().getService().collection(this.path).count().get().get(20L, TimeUnit.SECONDS)).getCount();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source, @NotNull Map<String, Object> options) throws DBCException {
        final FireStoreSession fireStoreSession = (FireStoreSession)session;
        return new ExecuteBatchImpl(attributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                FireStoreInsertStatement statement = new FireStoreInsertStatement(fireStoreSession, FireStoreCollection.this, this.attributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((FireStoreInsertStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        final FireStoreSession fireStoreSession = (FireStoreSession)session;
        return new ExecuteBatchImpl((DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes), null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                FireStoreUpdateStatement statement = new FireStoreUpdateStatement(fireStoreSession, FireStoreCollection.this, updateAttributes, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((FireStoreUpdateStatement)statement).addRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        final FireStoreSession fireStoreSession = (FireStoreSession)session;
        return new ExecuteBatchImpl(keyAttributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                FireStoreRemoveStatement statement = new FireStoreRemoveStatement(fireStoreSession, FireStoreCollection.this, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((FireStoreRemoveStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBSDataManipulator.ExecuteBatch batch = this.deleteData(session, new DBSAttributeBase[0], source);){
            return batch.execute(session, Collections.emptyMap());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        String[] names = this.getPath().split("/");
        StringJoiner joiner = new StringJoiner(".");
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if ("null".equals(name)) {
                joiner.add("\"null\"");
            } else {
                joiner.add(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)name));
            }
            ++n2;
        }
        return joiner.toString();
    }

    @Nullable
    public DBDDocument findDocument(@NotNull DBCSession session, @NotNull Map<String, Object> key, @Nullable Map<String, Object> metaData) throws DBException {
        Object object;
        DBDDocument document = null;
        if (metaData != null && (object = metaData.get("path")) instanceof String) {
            String path = (String)object;
            document = this.getDocumentByPath(session, path);
        }
        try {
            QuerySnapshot querySnapshot = (QuerySnapshot)((FireStoreExecutionContext)session.getExecutionContext()).getService().collection(this.getName()).get().get(30L, TimeUnit.SECONDS);
            for (QueryDocumentSnapshot queryDocumentSnapshot : querySnapshot.getDocuments()) {
                for (Map.Entry<String, Object> entry : key.entrySet()) {
                    String keyName = entry.getKey();
                    Object keyValue = entry.getValue();
                    if (keyValue == null || !queryDocumentSnapshot.getData().containsKey(keyName) || !keyValue.equals(queryDocumentSnapshot.getData().get(keyName))) continue;
                    document = this.getDocumentByPath(session, queryDocumentSnapshot.getReference().getPath());
                }
            }
            if (document != null) {
                return document;
            }
            throw new DBException("Firestore document path is not found");
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
    }

    @NotNull
    private DBDDocument getDocumentByPath(@NotNull DBCSession session, @NotNull String path) throws DBException {
        DocumentSnapshot documentSnapshot;
        try {
            documentSnapshot = (DocumentSnapshot)((FireStoreExecutionContext)session.getExecutionContext()).getService().document(path).get().get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new DBException(e.getMessage());
        }
        Map<String, Object> rawData = FirestoreUtils.enrichDocumentMapWithProperties(documentSnapshot.getData(), documentSnapshot.getId(), documentSnapshot.getReference().getPath());
        return new FireStoreDocument((FireStoreDatasource)session.getDataSource(), rawData, documentSnapshot.getId(), documentSnapshot.getReference().getPath(), documentSnapshot.getCreateTime().toSqlTimestamp());
    }

    public boolean isDocumentValid(@NotNull DBDDocument documentId) throws DBException {
        return documentId.getDocumentId() != null;
    }
}

