/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3fs.util;

import com.dbeaver.cloud.aws.s3fs.S3Path;
import com.dbeaver.cloud.aws.s3fs.attribute.S3BasicFileAttributes;
import com.dbeaver.cloud.aws.s3fs.attribute.S3PosixFileAttributes;
import com.dbeaver.cloud.aws.s3fs.attribute.S3UserPrincipal;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.dbeaver.Log;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.GetBucketAclRequest;
import software.amazon.awssdk.services.s3.model.GetBucketAclResponse;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAclResponse;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.Permission;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3Utils {
    private static final Log LOGGER = Log.getLog(S3Utils.class);

    public static List<S3Object> listS3Objects(S3Path s3Path) {
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        S3Client client = s3Path.getFileSystem().getClient();
        Object keyFolder = key;
        if (!((String)keyFolder).endsWith("/")) {
            keyFolder = (String)keyFolder + "/";
        }
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(bucketName).prefix((String)keyFolder).maxKeys(Integer.valueOf(1)).build();
        return client.listObjectsV2(request).contents();
    }

    public static S3Object getS3Object(S3Path s3Path) throws NoSuchFileException {
        S3Object s3Object = s3Path.getS3Object();
        if (s3Object != null) {
            return s3Object;
        }
        String bucketName = s3Path.getFileStore().name();
        String key = s3Path.getKey();
        if (key == null || key.isEmpty()) {
            Bucket bucket = s3Path.getFileStore().getBucket();
            return (S3Object)S3Object.builder().key(bucket.name()).lastModified(bucket.creationDate()).size(Long.valueOf(0L)).build();
        }
        S3Client client = s3Path.getFileSystem().getClient();
        try {
            HeadObjectRequest headObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(key).build();
            HeadObjectResponse metadata = client.headObject(headObjectRequest);
            S3Object.Builder builder = S3Object.builder();
            builder.key(key).lastModified(metadata.lastModified()).eTag(metadata.eTag()).size(metadata.contentLength()).storageClass(metadata.storageClassAsString());
            return (S3Object)builder.build();
        }
        catch (S3Exception e) {
            if (e.statusCode() != 404) {
                throw e;
            }
        }
        catch (SdkClientException sdkClientException) {
            LOGGER.warn((Object)"Object could not be retrieved as a file with the given key");
        }
        try {
            List<S3Object> s3Objects = S3Utils.listS3Objects(s3Path);
            if (!s3Objects.isEmpty()) {
                return s3Objects.get(0);
            }
        }
        catch (Exception exception) {}
        throw new NoSuchFileException(bucketName + "/" + key);
    }

    public S3BasicFileAttributes getS3FileAttributes(S3Path s3Path) throws NoSuchFileException {
        S3Object object = S3Utils.getS3Object(s3Path);
        return this.toS3FileAttributes(object, s3Path.getKey());
    }

    public S3PosixFileAttributes getS3PosixFileAttributes(S3Path s3Path) throws IOException {
        S3Object object = S3Utils.getS3Object(s3Path);
        String key = s3Path.getKey();
        S3BasicFileAttributes attrs = this.toS3FileAttributes(object, key);
        Set<PosixFilePermission> permissions = null;
        S3UserPrincipal userPrincipal = null;
        try {
            Owner owner;
            String bucketName = s3Path.getFileStore().name();
            S3Client client = s3Path.getFileSystem().getClient();
            if (!attrs.isDirectory()) {
                GetObjectAclRequest request = (GetObjectAclRequest)GetObjectAclRequest.builder().bucket(bucketName).key(key).build();
                GetObjectAclResponse acl = client.getObjectAcl(request);
                owner = acl.owner();
                permissions = this.toPosixFilePermissions(acl.grants());
            } else {
                GetBucketAclRequest request = (GetBucketAclRequest)GetBucketAclRequest.builder().bucket(bucketName).build();
                GetBucketAclResponse acl = client.getBucketAcl(request);
                owner = acl.owner();
                permissions = this.toPosixFilePermissions(acl.grants());
            }
            userPrincipal = new S3UserPrincipal(owner);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error reading resource permissions", (Throwable)e);
        }
        return new S3PosixFileAttributes(attrs.fileKey(), attrs.lastModifiedTime(), attrs.size(), attrs.isDirectory(), attrs.isRegularFile(), userPrincipal, null, permissions);
    }

    public Set<PosixFilePermission> toPosixFilePermissions(List<Grant> grants) {
        HashSet<PosixFilePermission> filePermissions = new HashSet<PosixFilePermission>();
        for (Grant grant : grants) {
            filePermissions.addAll(this.toPosixFilePermission(grant.permission()));
        }
        return filePermissions;
    }

    public Set<PosixFilePermission> toPosixFilePermission(Permission permission) {
        return switch (permission) {
            case Permission.FULL_CONTROL -> Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE});
            case Permission.WRITE -> Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE});
            case Permission.READ, Permission.READ_ACP -> Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ});
            case Permission.WRITE_ACP -> Sets.newHashSet((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE});
            default -> throw new IllegalStateException("Unknown Permission: " + String.valueOf(permission));
        };
    }

    public S3BasicFileAttributes toS3FileAttributes(S3Object object, String key) {
        FileTime lastModifiedTime = object.lastModified() != null ? FileTime.from(object.lastModified()) : FileTime.fromMillis(-1L);
        long size = object.size() != null ? object.size() : 0L;
        boolean directory = false;
        boolean regularFile = false;
        Object resolvedKey = object.key();
        if (key.endsWith("/") && ((String)resolvedKey).equals(key) || ((String)resolvedKey).equals(key + "/")) {
            directory = true;
        } else if (key.isEmpty()) {
            directory = true;
            resolvedKey = "/";
        } else if (!((String)resolvedKey).equals(key) && ((String)resolvedKey).startsWith(key)) {
            directory = true;
            size = 0L;
            resolvedKey = key + "/";
        } else {
            regularFile = true;
        }
        return new S3BasicFileAttributes((String)resolvedKey, lastModifiedTime, size, directory, regularFile);
    }
}

