/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3fs;

import com.dbeaver.cloud.aws.s3fs.S3Path;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class S3SeekableByteChannel
implements SeekableByteChannel {
    private final S3Path path;
    private final Set<? extends OpenOption> options;
    private final SeekableByteChannel seekable;
    private final Path tempFile;

    public S3SeekableByteChannel(S3Path path, Set<? extends OpenOption> options, boolean tempFileRequired) throws IOException {
        this.path = path;
        this.options = Collections.unmodifiableSet(new HashSet<OpenOption>(options));
        String key = path.getKey();
        boolean exists = path.getFileSystem().provider().exists(path);
        if (exists && this.options.contains(StandardOpenOption.CREATE_NEW)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", path));
        }
        if (!(exists || this.options.contains(StandardOpenOption.CREATE_NEW) || this.options.contains(StandardOpenOption.CREATE))) {
            throw new NoSuchFileException(String.format("target not exists: %s", path));
        }
        HashSet<? extends OpenOption> seekOptions = new HashSet<OpenOption>(this.options);
        seekOptions.remove(StandardOpenOption.CREATE_NEW);
        if (tempFileRequired) {
            this.tempFile = Files.createTempFile("s3fs-", ".tmp", new FileAttribute[0]);
            boolean removeTempFile = true;
            try {
                if (exists) {
                    S3Client client = path.getFileSystem().getClient();
                    String bucketName = path.getFileStore().getBucket().name();
                    GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
                    Throwable throwable = null;
                    Object var12_13 = null;
                    try (ResponseInputStream byteStream = client.getObject(request);){
                        Files.copy((InputStream)byteStream, this.tempFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.seekable = Files.newByteChannel(this.tempFile, seekOptions, new FileAttribute[0]);
                removeTempFile = false;
            }
            finally {
                if (removeTempFile) {
                    Files.deleteIfExists(this.tempFile);
                }
            }
        }
        this.tempFile = null;
        this.seekable = Files.newByteChannel((Path)path, seekOptions, new FileAttribute[0]);
    }

    @Override
    public boolean isOpen() {
        return this.seekable.isOpen();
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.seekable.isOpen()) {
                return;
            }
            this.seekable.close();
            if (this.options.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                this.path.getFileSystem().provider().delete(this.path);
                return;
            }
            if (this.options.contains(StandardOpenOption.READ) && this.options.size() == 1) {
                return;
            }
        }
        finally {
            if (this.tempFile != null) {
                Files.deleteIfExists(this.tempFile);
            }
        }
    }

    protected void sync() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(this.tempFile, new OpenOption[0]));){
            PutObjectRequest.Builder builder = PutObjectRequest.builder();
            long length = Files.size(this.tempFile);
            builder.contentLength(Long.valueOf(length));
            builder.bucket(this.path.getFileStore().name());
            builder.key(this.path.getKey());
            S3Client client = this.path.getFileSystem().getClient();
            client.putObject((PutObjectRequest)builder.build(), RequestBody.fromInputStream((InputStream)stream, (long)length));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.seekable.write(src);
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        return this.seekable.truncate(size);
    }

    @Override
    public long size() throws IOException {
        return this.seekable.size();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.seekable.read(dst);
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        return this.seekable.position(newPosition);
    }

    @Override
    public long position() throws IOException {
        return this.seekable.position();
    }
}

