/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3fs;

import com.dbeaver.cloud.aws.s3fs.S3AccessControlList;
import com.dbeaver.cloud.aws.s3fs.S3ClientFactory;
import com.dbeaver.cloud.aws.s3fs.S3Factory;
import com.dbeaver.cloud.aws.s3fs.S3FileChannel;
import com.dbeaver.cloud.aws.s3fs.S3FileSystem;
import com.dbeaver.cloud.aws.s3fs.S3FileSystemConfigurationException;
import com.dbeaver.cloud.aws.s3fs.S3InputStream;
import com.dbeaver.cloud.aws.s3fs.S3Iterator;
import com.dbeaver.cloud.aws.s3fs.S3OutputStream;
import com.dbeaver.cloud.aws.s3fs.S3Path;
import com.dbeaver.cloud.aws.s3fs.S3SeekableByteChannel;
import com.dbeaver.cloud.aws.s3fs.attribute.S3BasicFileAttributeView;
import com.dbeaver.cloud.aws.s3fs.attribute.S3BasicFileAttributes;
import com.dbeaver.cloud.aws.s3fs.attribute.S3PosixFileAttributeView;
import com.dbeaver.cloud.aws.s3fs.attribute.S3PosixFileAttributes;
import com.dbeaver.cloud.aws.s3fs.util.AttributesUtils;
import com.dbeaver.cloud.aws.s3fs.util.Cache;
import com.dbeaver.cloud.aws.s3fs.util.S3Utils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.util.Mimetype;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.StringUtils;

public class S3FileSystemProvider
extends FileSystemProvider {
    private static final Log log = Log.getLog(S3FileSystemProvider.class);
    public static final String S3_FACTORY_CLASS = "s3fs.amazon.s3.factory.class";
    private static final ConcurrentMap<String, S3FileSystem> fileSystems = new ConcurrentHashMap<String, S3FileSystem>();
    private static final List<String> PROPS_TO_OVERLOAD = Arrays.asList("s3fs.access.key", "s3fs.secret.key", "s3fs.request.metric.collector.class", "s3fs.connection.timeout", "s3fs.max.connections", "s3fs.max.retry.error", "s3fs.protocol", "s3fs.proxy.domain", "s3fs.proxy.host", "s3fs.proxy.password", "s3fs.proxy.port", "s3fs.proxy.username", "s3fs.proxy.workstation", "s3fs.region", "s3fs.socket.send.buffer.size.hint", "s3fs.socket.receive.buffer.size.hint", "s3fs.socket.timeout", "s3fs.user.agent", "s3fs.amazon.s3.factory.class", "s3fs.signer.override", "s3fs.path.style.access");
    private static final int MAX_OBJECT_PER_REQUEST = 1000;
    private static final Log LOGGER = Log.getLog(S3FileSystemProvider.class);
    private final S3Utils s3Utils = new S3Utils();
    private final Cache cache = new Cache();

    @Override
    public String getScheme() {
        return "s3";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            throw new FileSystemAlreadyExistsException("File system " + uri.getScheme() + ":" + key + " already exists");
        }
        S3FileSystem fileSystem = this.createFileSystem(uri, props);
        fileSystems.put(fileSystem.getKey(), fileSystem);
        return fileSystem;
    }

    private Properties getProperties(URI uri, Map<String, ?> env) {
        Properties props = this.loadAmazonProperties();
        this.addEnvProperties(props, env);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] keys = userInfo.split(":");
            props.setProperty("s3fs.access.key", keys[0]);
            if (keys.length > 1) {
                props.setProperty("s3fs.secret.key", keys[1]);
            }
        }
        return props;
    }

    private String getFileSystemKey(URI uri) {
        return this.getFileSystemKey(uri, this.getProperties(uri, null));
    }

    protected String getFileSystemKey(URI uri, Properties props) {
        String uriString = uri.toString().replaceAll("s3://", "");
        String authority = null;
        int authoritySeparator = uriString.indexOf("@");
        if (authoritySeparator > 0) {
            authority = uriString.substring(0, authoritySeparator);
        }
        if (authority != null) {
            String host = uriString.substring(uriString.indexOf("@") + 1);
            int lastPath = host.indexOf("/");
            if (lastPath > -1) {
                host = host.substring(0, lastPath);
            }
            if (host.isEmpty()) {
                host = "s3.amazonaws.com";
            }
            return authority + "@" + host;
        }
        String accessKey = (String)props.get("s3fs.access.key");
        return (String)(accessKey != null ? accessKey + "@" : "") + (uri.getHost() != null ? uri.getHost() : "s3.amazonaws.com");
    }

    protected void validateUri(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri is null");
        Preconditions.checkArgument((boolean)uri.getScheme().equals(this.getScheme()), (String)"uri scheme must be 's3': '%s'", (Object)uri);
    }

    protected void addEnvProperties(Properties props, Map<String, ?> env) {
        if (env == null) {
            env = new HashMap();
        }
        for (String string : PROPS_TO_OVERLOAD) {
            this.overloadProperty(props, env, string);
        }
        for (Map.Entry entry : env.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (PROPS_TO_OVERLOAD.contains(key)) continue;
            props.put(key, value);
        }
    }

    private void overloadProperty(Properties props, Map<String, ?> env, String key) {
        boolean overloaded = this.overloadPropertiesWithEnv(props, env, key);
        if (!overloaded) {
            overloaded = this.overloadPropertiesWithSystemProps(props, key);
        }
        if (!overloaded) {
            this.overloadPropertiesWithSystemEnv(props, key);
        }
    }

    protected boolean overloadPropertiesWithEnv(Properties props, Map<String, ?> env, String key) {
        if (env.get(key) instanceof String) {
            props.setProperty(key, (String)env.get(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemProps(Properties props, String key) {
        if (System.getProperty(key) != null) {
            props.setProperty(key, System.getProperty(key));
            return true;
        }
        return false;
    }

    public boolean overloadPropertiesWithSystemEnv(Properties props, String key) {
        if (this.systemGetEnv(key) != null) {
            props.setProperty(key, this.systemGetEnv(key));
            return true;
        }
        return false;
    }

    public String systemGetEnv(String key) {
        return System.getenv(key);
    }

    public FileSystem getFileSystem(URI uri, Map<String, ?> env) {
        this.validateUri(uri);
        Properties props = this.getProperties(uri, env);
        String key = this.getFileSystemKey(uri, props);
        if (fileSystems.containsKey(key)) {
            return (FileSystem)fileSystems.get(key);
        }
        return this.newFileSystem(uri, env);
    }

    @Override
    public S3FileSystem getFileSystem(URI uri) {
        this.validateUri(uri);
        String key = this.getFileSystemKey(uri);
        if (fileSystems.containsKey(key)) {
            return (S3FileSystem)fileSystems.get(key);
        }
        throw new FileSystemNotFoundException("S3 filesystem not yet created. Use newFileSystem() instead");
    }

    private S3Path toS3Path(Path path) throws IllegalArgumentException {
        if (path instanceof S3Path) {
            S3Path s3Path = (S3Path)path;
            return s3Path;
        }
        throw new IllegalArgumentException("Path must be an instance of " + S3Path.class.getName());
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        S3FileSystem fileSystem = this.getFileSystem(uri);
        return ((FileSystem)fileSystem).getPath(uri.getPath(), new String[0]);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
        final S3Path s3Path = this.toS3Path(dir);
        return new DirectoryStream<Path>(){

            @Override
            public void close() {
            }

            @Override
            @NotNull
            public Iterator<Path> iterator() {
                return new S3Iterator(s3Path);
            }
        };
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        String key = s3Path.getKey();
        String bucketName = s3Path.getFileStore().name();
        if (options.length != 0) {
            throw new IOException("OpenOptions not yet supported on S3 - " + Arrays.toString(options));
        }
        if (key.isEmpty()) {
            throw new IOException("Cannot create InputStream for root directory: " + String.valueOf(path));
        }
        try {
            S3Client client = s3Path.getFileSystem().getClient();
            GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
            ResponseInputStream res = client.getObject(request);
            if (res == null) {
                throw new IOException(String.format("The specified path is a directory: %s", path));
            }
            log.debug((Object)String.format("Start reading S3 stream: [path=%s]", path));
            return new S3InputStream((ResponseInputStream<GetObjectResponse>)res);
        }
        catch (S3Exception e) {
            if (e.statusCode() == 404) {
                throw new NoSuchFileException(path.toString());
            }
            throw new IOException(String.format("Cannot access file: %s", path), e);
        }
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (options.length > 0) {
            LinkedHashSet<OpenOption> opts = new LinkedHashSet<OpenOption>(Arrays.asList(options));
            if (opts.contains(StandardOpenOption.APPEND)) {
                return super.newOutputStream(path, options);
            }
            if (opts.contains(StandardOpenOption.READ)) {
                throw new IllegalArgumentException("READ not allowed");
            }
            boolean create = opts.remove(StandardOpenOption.CREATE);
            boolean createNew = opts.remove(StandardOpenOption.CREATE_NEW);
            boolean truncateExisting = opts.remove(StandardOpenOption.TRUNCATE_EXISTING);
            opts.remove(StandardOpenOption.WRITE);
            opts.remove(StandardOpenOption.SPARSE);
            if (!opts.isEmpty()) {
                throw new UnsupportedOperationException(String.valueOf(opts.iterator().next()) + " not supported");
            }
            this.validateCreateAndTruncateOptions(path, s3Path, create, createNew, truncateExisting);
        }
        Map<String, String> metadata = this.buildMetadataFromPath(path);
        log.debug((Object)String.format("Start writing to S3 stream: [path=%s]", path));
        return new S3OutputStream(s3Path.getFileSystem().getClient(), s3Path.toS3ObjectId(), metadata);
    }

    private void validateCreateAndTruncateOptions(Path path, S3Path s3Path, boolean create, boolean createNew, boolean truncateExisting) throws FileAlreadyExistsException, NoSuchFileException {
        if (!create || !truncateExisting) {
            if (s3Path.getFileSystem().provider().exists(s3Path)) {
                if (createNew || !truncateExisting) {
                    throw new FileAlreadyExistsException(String.format("The target already exists: %s", path));
                }
            } else if (!createNew && !create) {
                throw new NoSuchFileException(String.format("The target does not exist: %s", path));
            }
        }
    }

    private Map<String, String> buildMetadataFromPath(Path path) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        String contentType = Mimetype.getInstance().getMimetype(path);
        if (!StringUtils.isEmpty((CharSequence)contentType)) {
            metadata.put("Content-Type", contentType);
        }
        return metadata;
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        return new S3SeekableByteChannel(s3Path, options, true);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        return new S3FileChannel(s3Path, options, executor, true);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        S3Path s3Path = this.toS3Path(dir);
        S3Client client = s3Path.getFileSystem().getClient();
        if (!ArrayUtils.isEmpty((Object[])attrs)) {
            throw new IOException("attrs not yet supported: " + Arrays.toString(attrs));
        }
        if (this.exists(s3Path)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", s3Path));
        }
        Bucket bucket = s3Path.getFileStore().getBucket();
        String bucketName = s3Path.getFileStore().name();
        if (bucket == null) {
            CreateBucketRequest request = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build();
            client.createBucket(request);
        }
        Object directoryKey = s3Path.getKey().endsWith("/") ? s3Path.getKey() : s3Path.getKey() + "/";
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key((String)directoryKey).contentLength(Long.valueOf(0L)).build();
        client.putObject(request, RequestBody.fromBytes((byte[])new byte[0]));
    }

    @Override
    public void delete(Path path) throws IOException {
        S3Path rootPath = this.toS3Path(path);
        S3Client client = rootPath.getFileSystem().getClient();
        String bucketName = rootPath.getFileStore().name();
        List<Deque<S3Path>> s3Paths = this.getPathsByBatch(rootPath);
        for (Deque<S3Path> batch : s3Paths) {
            this.deleteBatch(client, batch, bucketName);
        }
        log.debug((Object)String.format("S3 file deleted: [path=%s]", path));
    }

    private void deleteBatch(S3Client client, Deque<S3Path> batch, String bucketName) throws IOException {
        List keys = batch.stream().map(s3Path -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3Path.getKey()).build()).collect(Collectors.toList());
        DeleteObjectsRequest multiObjectDeleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(keys).build()).build();
        try {
            client.deleteObjects(multiObjectDeleteRequest);
        }
        catch (SdkException e) {
            throw new IOException(e);
        }
        keys = batch.stream().map(s3Path -> (ObjectIdentifier)ObjectIdentifier.builder().key(s3Path.getKey() + "/").build()).collect(Collectors.toList());
        multiObjectDeleteRequest = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(keys).build()).build();
        try {
            client.deleteObjects(multiObjectDeleteRequest);
        }
        catch (SdkException e) {
            throw new IOException(e);
        }
    }

    private List<Deque<S3Path>> getPathsByBatch(S3Path path) throws IOException {
        LinkedList<S3Path> allPaths = new LinkedList<S3Path>();
        this.visitAllFiles(path, allPaths);
        return this.splitByBatchWithOrder(allPaths, 1000);
    }

    private <T> List<Deque<T>> splitByBatchWithOrder(List<T> list, int maxSize) {
        LinkedList<Deque<T>> pathsByBatch = new LinkedList<Deque<T>>();
        if (!list.isEmpty()) {
            ArrayDeque<T> deque = new ArrayDeque<T>();
            for (T t : list) {
                if (deque.size() < maxSize) {
                    deque.push(t);
                    continue;
                }
                pathsByBatch.add(deque);
                deque = new ArrayDeque();
            }
            pathsByBatch.add(deque);
        }
        return pathsByBatch;
    }

    private void visitAllFiles(Path path, LinkedList<S3Path> paths) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (Files.notExists(s3Path, new LinkOption[0])) {
            LOGGER.warn((Object)("Deleting " + String.valueOf(s3Path) + " was skipped because the path was not found."));
        } else {
            paths.add(s3Path);
            if (Files.isDirectory(s3Path, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(s3Path);){
                        for (Path child : stream) {
                            this.visitAllFiles(child, paths);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SecurityException securityException) {
                    LOGGER.warn((Object)("Deleting " + String.valueOf(s3Path) + " was skipped because the path could not be read-accessed."));
                }
            }
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (this.isSameFile(source, target)) {
            return;
        }
        S3Path s3Source = this.toS3Path(source);
        S3Path s3Target = this.toS3Path(target);
        if (Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("Copying source directories is not supported by S3");
        }
        if (Files.isDirectory(target, new LinkOption[0])) {
            throw new IOException("Copying to target directory is not supported by S3");
        }
        ImmutableSet actualOptions = ImmutableSet.copyOf((Object[])options);
        this.verifySupportedOptions((Set)EnumSet.of(StandardCopyOption.REPLACE_EXISTING), (Set)actualOptions);
        if (this.exists(s3Target) && !actualOptions.contains((Object)StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileAlreadyExistsException(String.format("target already exists: %s", target));
        }
        String bucketNameOrigin = s3Source.getFileStore().name();
        String keySource = s3Source.getKey();
        String bucketNameTarget = s3Target.getFileStore().name();
        String keyTarget = s3Target.getKey();
        S3Client client = s3Source.getFileSystem().getClient();
        CopyObjectRequest request = (CopyObjectRequest)CopyObjectRequest.builder().sourceBucket(bucketNameOrigin).sourceKey(keySource).destinationBucket(bucketNameTarget).destinationKey(keyTarget).build();
        client.copyObject(request);
        log.debug((Object)String.format("S3 file copied: [source=%s, destination=%s]", source, target));
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        if (options != null && Arrays.asList(options).contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new AtomicMoveNotSupportedException(source.toString(), target.toString(), "Atomic not supported");
        }
        if (Files.isDirectory(source, new LinkOption[0]) || Files.isDirectory(target, new LinkOption[0])) {
            throw new IOException("Move/rename is supported for individual files only");
        }
        this.copy(source, target, options);
        this.delete(source);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) {
        return path1.isAbsolute() && path2.isAbsolute() && path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (!s3Path.isAbsolute()) {
            throw new IOException("S3 path must be absolute: " + String.valueOf(s3Path));
        }
        if (!this.exists(s3Path)) {
            throw new NoSuchFileException(this.toString());
        }
        if (modes.length > 0) {
            S3Object s3Object = S3Utils.getS3Object(s3Path);
            String key = s3Object.key();
            String bucket = s3Path.getFileStore().name();
            S3AccessControlList accessControlList = new S3AccessControlList(bucket, key);
            accessControlList.checkAccess(modes);
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        S3Path s3Path = this.toS3Path(path);
        if (type == BasicFileAttributeView.class) {
            return (V)new S3BasicFileAttributeView(s3Path);
        }
        if (type == PosixFileAttributeView.class) {
            return (V)new S3PosixFileAttributeView(s3Path);
        }
        if (type == null) {
            throw new NullPointerException("Type is mandatory");
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        S3Path s3Path = this.toS3Path(path);
        if (type == BasicFileAttributes.class) {
            if (this.cache.isInTime(s3Path.getFileSystem().getCache(), s3Path.getFileAttributes())) {
                return (A)((BasicFileAttributes)type.cast(s3Path.getFileAttributes()));
            }
            S3BasicFileAttributes attrs = this.s3Utils.getS3FileAttributes(s3Path);
            s3Path.setFileAttributes(attrs);
            return (A)((BasicFileAttributes)type.cast(attrs));
        }
        if (type == PosixFileAttributes.class) {
            if (s3Path.getFileAttributes() instanceof PosixFileAttributes && this.cache.isInTime(s3Path.getFileSystem().getCache(), s3Path.getFileAttributes())) {
                BasicFileAttributes result = (BasicFileAttributes)type.cast(s3Path.getFileAttributes());
                s3Path.setFileAttributes(null);
                return (A)result;
            }
            S3PosixFileAttributes attrs = this.s3Utils.getS3PosixFileAttributes(s3Path);
            s3Path.setFileAttributes(attrs);
            return (A)((BasicFileAttributes)type.cast(attrs));
        }
        throw new UnsupportedOperationException(String.format("only %s or %s supported", BasicFileAttributes.class, PosixFileAttributes.class));
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes null");
        }
        if (attributes.contains(":") && !attributes.contains("basic:") && !attributes.contains("posix:")) {
            throw new UnsupportedOperationException(String.format("attributes %s are not supported, only basic / posix are supported", attributes));
        }
        if (attributes.equals("*") || attributes.equals("basic:*")) {
            BasicFileAttributes attr = this.readAttributes(path, BasicFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        if (attributes.equals("posix:*")) {
            PosixFileAttributes attr = this.readAttributes(path, PosixFileAttributes.class, options);
            return AttributesUtils.fileAttributeToMap(attr);
        }
        String[] filters = new String[]{attributes};
        if (attributes.contains(",")) {
            filters = attributes.split(",");
        }
        Class<BasicFileAttributes> filter = BasicFileAttributes.class;
        if (attributes.startsWith("posix:")) {
            filter = PosixFileAttributes.class;
        }
        return AttributesUtils.fileAttributeToMap(this.readAttributes(path, filter, options), filters);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        throw new UnsupportedOperationException();
    }

    public S3FileSystem createFileSystem(URI uri, Properties props) {
        String key = this.getFileSystemKey(uri, props);
        S3Client client = this.getS3Client(uri, props);
        String host = uri.getHost();
        String bucketName = key;
        if ("s3.amazonaws.com".equals(bucketName)) {
            ArrayList paths = Lists.newArrayList((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)uri.getPath()));
            bucketName = CommonUtils.isEmpty((Collection)paths) ? null : (String)paths.get(0);
        }
        Bucket bucket = bucketName == null ? null : (Bucket)Bucket.builder().name(bucketName).build();
        return new S3FileSystem(this, key, bucket, () -> client, host);
    }

    protected S3Client getS3Client(URI uri, Properties props) {
        S3Factory factory = this.getS3Factory(props);
        return factory.getS3Client(uri, props);
    }

    protected S3Factory getS3Factory(Properties props) {
        if (props.containsKey(S3_FACTORY_CLASS)) {
            String s3FactoryClass = props.getProperty(S3_FACTORY_CLASS);
            try {
                return (S3Factory)Class.forName(s3FactoryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new S3FileSystemConfigurationException("Configuration problem, couldn't instantiate S3Factory (" + s3FactoryClass + "): ", e);
            }
        }
        return new S3ClientFactory();
    }

    public Properties loadAmazonProperties() {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("amazon.properties");){
                if (in != null) {
                    props.load(in);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return props;
    }

    private <T> void verifySupportedOptions(Set<? extends T> allowedOptions, Set<? extends T> actualOptions) throws IOException {
        Sets.SetView unsupported = Sets.difference(actualOptions, allowedOptions);
        if (!unsupported.isEmpty()) {
            throw new IOException("The following options are not supported: " + String.valueOf(unsupported));
        }
    }

    private static boolean isBucketRoot(S3Path s3Path) {
        String key = s3Path.getKey();
        return key.isEmpty() || key.equals("/");
    }

    boolean exists(S3Path path) {
        S3Path s3Path = this.toS3Path(path);
        if (S3FileSystemProvider.isBucketRoot(s3Path)) {
            try {
                S3Utils.listS3Objects(s3Path);
                return true;
            }
            catch (SdkException sdkException) {
                return false;
            }
        }
        try {
            S3Utils.getS3Object(s3Path);
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
    }

    public boolean close(S3FileSystem fileSystem) {
        if (fileSystem.getKey() != null) {
            return fileSystems.remove(fileSystem.getKey()) != null;
        }
        return false;
    }

    public boolean isOpen(S3FileSystem s3FileSystem) {
        return fileSystems.containsKey(s3FileSystem.getKey());
    }

    protected static ConcurrentMap<String, S3FileSystem> getFilesystems() {
        return fileSystems;
    }
}

