/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.s3;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.s3.AWSFileSystemS3Bucket;
import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.model.AbstractCloudVirtualFileSystem;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListBucketsRequest;

public class AWSFileSystemS3
extends AbstractCloudVirtualFileSystem<AWSFileSystemS3Bucket, AWSCloud> {
    public AWSFileSystemS3(AWSCloud cloud, SMSessionContext sessionContext) {
        super((AbstractCloud)cloud, sessionContext);
    }

    @NotNull
    public String getProviderId() {
        return "aws-s3";
    }

    public DBPImage getIcon() {
        return null;
    }

    public SMSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @NotNull
    public String getFileSystemDisplayName() {
        return ((AWSCloudConfiguration)((AWSCloud)this.cloud).getCloudConfiguration()).getCloudName();
    }

    @NotNull
    public String getType() {
        return "s3";
    }

    public String getDescription() {
        return "S3 file system for " + ((AWSCloud)this.cloud).getName();
    }

    @NotNull
    public String getId() {
        return ((AWSCloud)this.cloud).getCloudId();
    }

    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor monitor, @NotNull URI uri) throws DBException {
        Object[] pathParts = CommonUtils.removeLeadingSlash((String)uri.getPath()).split("/");
        if (ArrayUtils.isEmpty((Object[])pathParts)) {
            throw new DBException("Bucket name not present in uri: " + String.valueOf(uri));
        }
        Object bucketName = pathParts[0];
        List roots = this.getRootFolders(monitor);
        DBFVirtualFileSystemRoot rootBucket = (DBFVirtualFileSystemRoot)roots.stream().filter(arg_0 -> AWSFileSystemS3.lambda$0((String)bucketName, arg_0)).findFirst().orElseThrow(() -> AWSFileSystemS3.lambda$1((String)bucketName));
        if (pathParts.length == 1) {
            return rootBucket.getRootPath(monitor);
        }
        String filePath = String.join((CharSequence)"/", (CharSequence[])Arrays.copyOfRange(pathParts, 1, pathParts.length));
        return rootBucket.getRootPath(monitor).resolve(filePath);
    }

    public AWSCloud getCloud() {
        return (AWSCloud)this.cloud;
    }

    S3Client getS3Client(DBRProgressMonitor monitor, Region region) throws DBException {
        AuthModelAWSCredentials iamCredentials = this.getActiveCredentials(monitor);
        AwsCredentialsProvider credentialsProvider = iamCredentials.getAuthCredentialsProvider(monitor, null, region.id());
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider(credentialsProvider)).httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder().connectionTimeout(Duration.ofSeconds(10L)).socketTimeout(Duration.ofSeconds(10L)));
        if (region != null) {
            s3ClientBuilder.region(region);
        }
        return (S3Client)s3ClientBuilder.build();
    }

    private AuthModelAWSCredentials getActiveCredentials(DBRProgressMonitor monitor) throws DBException {
        SMSession spaceSession = this.sessionContext.getSpaceSession(monitor, (SMAuthSpace)this.cloud, true);
        if (!(spaceSession instanceof AWSCloudSession)) {
            throw new DBException("Can't obtain AWS cloud session from context");
        }
        return ((AWSCloudSession)spaceSession).getIamCredentials();
    }

    protected boolean useUriHostNameAsSegment(URI uri) {
        return false;
    }

    protected List<AWSFileSystemS3Bucket> getBucketsFromCloudSystem(DBRProgressMonitor monitor) throws DBException {
        AuthModelAWSCredentials credentials = this.getActiveCredentials(monitor);
        if (credentials == null) {
            throw new DBException("Error of obtaining auth credential.");
        }
        List<Region> regions = Arrays.stream(((AWSCloud)this.cloud).getCloudAssignedZones()).map(AWSCloudZone::getRegion).toList();
        try {
            monitor.beginTask("Read S3 buckets", regions.size());
            HashMap<Region, S3Client> clients = new HashMap<Region, S3Client>();
            for (Region region : regions) {
                monitor.subTask("Acquire S3 client for region " + region.id());
                S3Client client = (S3Client)AWSIAMUtils.tryExecuteRecover((DBRProgressMonitor)monitor, (AuthModelAWSCredentials)credentials, () -> this.getS3Client(monitor, region));
                clients.put(region, client);
            }
            List<AWSFileSystemS3Bucket> result = Collections.synchronizedList(new ArrayList());
            RuntimeUtils.executeJobsForEach(clients.entrySet(), (monitor1, entry) -> {
                List buckets = ((S3Client)entry.getValue()).listBuckets((ListBucketsRequest)ListBucketsRequest.builder().bucketRegion(((Region)entry.getKey()).id()).build()).buckets();
                for (Bucket bucket : buckets) {
                    result.add(new AWSFileSystemS3Bucket(this, (Region)entry.getKey(), bucket));
                }
                monitor.worked(1);
            });
            return result;
        }
        catch (Exception e) {
            throw new DBException("Error occurred during refresh S3 File System.", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$0(String string, AWSFileSystemS3Bucket bucket) {
        return bucket.getName().equals(string);
    }

    private static /* synthetic */ DBException lambda$1(String string) {
        return new DBException("Cannot find bucket '" + string + "'");
    }
}

