/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.EvaluationDataset;
import software.amazon.awssdk.services.bedrock.model.EvaluationMetricNamesCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluationTaskType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationDatasetMetricConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationDatasetMetricConfig> {
    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskType").getter(EvaluationDatasetMetricConfig.getter(EvaluationDatasetMetricConfig::taskTypeAsString)).setter(EvaluationDatasetMetricConfig.setter(Builder::taskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskType").build()}).build();
    private static final SdkField<EvaluationDataset> DATASET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataset").getter(EvaluationDatasetMetricConfig.getter(EvaluationDatasetMetricConfig::dataset)).setter(EvaluationDatasetMetricConfig.setter(Builder::dataset)).constructor(EvaluationDataset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()}).build();
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricNames").getter(EvaluationDatasetMetricConfig.getter(EvaluationDatasetMetricConfig::metricNames)).setter(EvaluationDatasetMetricConfig.setter(Builder::metricNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_TYPE_FIELD, DATASET_FIELD, METRIC_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationDatasetMetricConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String taskType;
    private final EvaluationDataset dataset;
    private final List<String> metricNames;

    private EvaluationDatasetMetricConfig(BuilderImpl builder) {
        this.taskType = builder.taskType;
        this.dataset = builder.dataset;
        this.metricNames = builder.metricNames;
    }

    public final EvaluationTaskType taskType() {
        return EvaluationTaskType.fromValue(this.taskType);
    }

    public final String taskTypeAsString() {
        return this.taskType;
    }

    public final EvaluationDataset dataset() {
        return this.dataset;
    }

    public final boolean hasMetricNames() {
        return this.metricNames != null && !(this.metricNames instanceof SdkAutoConstructList);
    }

    public final List<String> metricNames() {
        return this.metricNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricNames() ? this.metricNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationDatasetMetricConfig)) {
            return false;
        }
        EvaluationDatasetMetricConfig other = (EvaluationDatasetMetricConfig)obj;
        return Objects.equals(this.taskTypeAsString(), other.taskTypeAsString()) && Objects.equals(this.dataset(), other.dataset()) && this.hasMetricNames() == other.hasMetricNames() && Objects.equals(this.metricNames(), other.metricNames());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationDatasetMetricConfig").add("TaskType", (Object)this.taskTypeAsString()).add("Dataset", (Object)this.dataset()).add("MetricNames", (Object)(this.metricNames() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskType": {
                return Optional.ofNullable(clazz.cast(this.taskTypeAsString()));
            }
            case "dataset": {
                return Optional.ofNullable(clazz.cast(this.dataset()));
            }
            case "metricNames": {
                return Optional.ofNullable(clazz.cast(this.metricNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskType", TASK_TYPE_FIELD);
        map.put("dataset", DATASET_FIELD);
        map.put("metricNames", METRIC_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationDatasetMetricConfig, T> g) {
        return obj -> g.apply((EvaluationDatasetMetricConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskType;
        private EvaluationDataset dataset;
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationDatasetMetricConfig model) {
            this.taskType(model.taskType);
            this.dataset(model.dataset);
            this.metricNames(model.metricNames);
        }

        public final String getTaskType() {
            return this.taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(EvaluationTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final EvaluationDataset.Builder getDataset() {
            return this.dataset != null ? this.dataset.toBuilder() : null;
        }

        public final void setDataset(EvaluationDataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(EvaluationDataset dataset) {
            this.dataset = dataset;
            return this;
        }

        public final Collection<String> getMetricNames() {
            if (this.metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = EvaluationMetricNamesCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNames(Collection<String> metricNames) {
            this.metricNames = EvaluationMetricNamesCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(String ... metricNames) {
            this.metricNames(Arrays.asList(metricNames));
            return this;
        }

        public EvaluationDatasetMetricConfig build() {
            return new EvaluationDatasetMetricConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationDatasetMetricConfig> {
        public Builder taskType(String var1);

        public Builder taskType(EvaluationTaskType var1);

        public Builder dataset(EvaluationDataset var1);

        default public Builder dataset(Consumer<EvaluationDataset.Builder> dataset) {
            return this.dataset((EvaluationDataset)((EvaluationDataset.Builder)EvaluationDataset.builder().applyMutation(dataset)).build());
        }

        public Builder metricNames(Collection<String> var1);

        public Builder metricNames(String ... var1);
    }
}

