/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyConflictedRuleIdListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeNameListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePair;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionTypeValuePairListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariableNameListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSet;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointRuleSetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyDefinitionQualityReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionQualityReport> {
    private static final SdkField<Integer> TYPE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("typeCount").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::typeCount)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::typeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeCount").build()}).build();
    private static final SdkField<Integer> VARIABLE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("variableCount").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::variableCount)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::variableCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableCount").build()}).build();
    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ruleCount").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::ruleCount)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::ruleCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleCount").build()}).build();
    private static final SdkField<List<String>> UNUSED_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unusedTypes").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedTypes)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::unusedTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyDefinitionTypeValuePair>> UNUSED_TYPE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unusedTypeValues").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedTypeValues)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::unusedTypeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedTypeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyDefinitionTypeValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> UNUSED_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unusedVariables").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::unusedVariables)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::unusedVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONFLICTING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conflictingRules").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::conflictingRules)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::conflictingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyDisjointRuleSet>> DISJOINT_RULE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("disjointRuleSets").getter(AutomatedReasoningPolicyDefinitionQualityReport.getter(AutomatedReasoningPolicyDefinitionQualityReport::disjointRuleSets)).setter(AutomatedReasoningPolicyDefinitionQualityReport.setter(Builder::disjointRuleSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disjointRuleSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyDisjointRuleSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_COUNT_FIELD, VARIABLE_COUNT_FIELD, RULE_COUNT_FIELD, UNUSED_TYPES_FIELD, UNUSED_TYPE_VALUES_FIELD, UNUSED_VARIABLES_FIELD, CONFLICTING_RULES_FIELD, DISJOINT_RULE_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyDefinitionQualityReport.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer typeCount;
    private final Integer variableCount;
    private final Integer ruleCount;
    private final List<String> unusedTypes;
    private final List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues;
    private final List<String> unusedVariables;
    private final List<String> conflictingRules;
    private final List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets;

    private AutomatedReasoningPolicyDefinitionQualityReport(BuilderImpl builder) {
        this.typeCount = builder.typeCount;
        this.variableCount = builder.variableCount;
        this.ruleCount = builder.ruleCount;
        this.unusedTypes = builder.unusedTypes;
        this.unusedTypeValues = builder.unusedTypeValues;
        this.unusedVariables = builder.unusedVariables;
        this.conflictingRules = builder.conflictingRules;
        this.disjointRuleSets = builder.disjointRuleSets;
    }

    public final Integer typeCount() {
        return this.typeCount;
    }

    public final Integer variableCount() {
        return this.variableCount;
    }

    public final Integer ruleCount() {
        return this.ruleCount;
    }

    public final boolean hasUnusedTypes() {
        return this.unusedTypes != null && !(this.unusedTypes instanceof SdkAutoConstructList);
    }

    public final List<String> unusedTypes() {
        return this.unusedTypes;
    }

    public final boolean hasUnusedTypeValues() {
        return this.unusedTypeValues != null && !(this.unusedTypeValues instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues() {
        return this.unusedTypeValues;
    }

    public final boolean hasUnusedVariables() {
        return this.unusedVariables != null && !(this.unusedVariables instanceof SdkAutoConstructList);
    }

    public final List<String> unusedVariables() {
        return this.unusedVariables;
    }

    public final boolean hasConflictingRules() {
        return this.conflictingRules != null && !(this.conflictingRules instanceof SdkAutoConstructList);
    }

    public final List<String> conflictingRules() {
        return this.conflictingRules;
    }

    public final boolean hasDisjointRuleSets() {
        return this.disjointRuleSets != null && !(this.disjointRuleSets instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets() {
        return this.disjointRuleSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnusedTypes() ? this.unusedTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnusedTypeValues() ? this.unusedTypeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnusedVariables() ? this.unusedVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConflictingRules() ? this.conflictingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisjointRuleSets() ? this.disjointRuleSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDefinitionQualityReport)) {
            return false;
        }
        AutomatedReasoningPolicyDefinitionQualityReport other = (AutomatedReasoningPolicyDefinitionQualityReport)obj;
        return Objects.equals(this.typeCount(), other.typeCount()) && Objects.equals(this.variableCount(), other.variableCount()) && Objects.equals(this.ruleCount(), other.ruleCount()) && this.hasUnusedTypes() == other.hasUnusedTypes() && Objects.equals(this.unusedTypes(), other.unusedTypes()) && this.hasUnusedTypeValues() == other.hasUnusedTypeValues() && Objects.equals(this.unusedTypeValues(), other.unusedTypeValues()) && this.hasUnusedVariables() == other.hasUnusedVariables() && Objects.equals(this.unusedVariables(), other.unusedVariables()) && this.hasConflictingRules() == other.hasConflictingRules() && Objects.equals(this.conflictingRules(), other.conflictingRules()) && this.hasDisjointRuleSets() == other.hasDisjointRuleSets() && Objects.equals(this.disjointRuleSets(), other.disjointRuleSets());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyDefinitionQualityReport").add("TypeCount", (Object)this.typeCount()).add("VariableCount", (Object)this.variableCount()).add("RuleCount", (Object)this.ruleCount()).add("UnusedTypes", (Object)(this.unusedTypes() == null ? null : "*** Sensitive Data Redacted ***")).add("UnusedTypeValues", this.hasUnusedTypeValues() ? this.unusedTypeValues() : null).add("UnusedVariables", (Object)(this.unusedVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("ConflictingRules", this.hasConflictingRules() ? this.conflictingRules() : null).add("DisjointRuleSets", this.hasDisjointRuleSets() ? this.disjointRuleSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "typeCount": {
                return Optional.ofNullable(clazz.cast(this.typeCount()));
            }
            case "variableCount": {
                return Optional.ofNullable(clazz.cast(this.variableCount()));
            }
            case "ruleCount": {
                return Optional.ofNullable(clazz.cast(this.ruleCount()));
            }
            case "unusedTypes": {
                return Optional.ofNullable(clazz.cast(this.unusedTypes()));
            }
            case "unusedTypeValues": {
                return Optional.ofNullable(clazz.cast(this.unusedTypeValues()));
            }
            case "unusedVariables": {
                return Optional.ofNullable(clazz.cast(this.unusedVariables()));
            }
            case "conflictingRules": {
                return Optional.ofNullable(clazz.cast(this.conflictingRules()));
            }
            case "disjointRuleSets": {
                return Optional.ofNullable(clazz.cast(this.disjointRuleSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("typeCount", TYPE_COUNT_FIELD);
        map.put("variableCount", VARIABLE_COUNT_FIELD);
        map.put("ruleCount", RULE_COUNT_FIELD);
        map.put("unusedTypes", UNUSED_TYPES_FIELD);
        map.put("unusedTypeValues", UNUSED_TYPE_VALUES_FIELD);
        map.put("unusedVariables", UNUSED_VARIABLES_FIELD);
        map.put("conflictingRules", CONFLICTING_RULES_FIELD);
        map.put("disjointRuleSets", DISJOINT_RULE_SETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDefinitionQualityReport, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDefinitionQualityReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer typeCount;
        private Integer variableCount;
        private Integer ruleCount;
        private List<String> unusedTypes = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> unusedVariables = DefaultSdkAutoConstructList.getInstance();
        private List<String> conflictingRules = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDefinitionQualityReport model) {
            this.typeCount(model.typeCount);
            this.variableCount(model.variableCount);
            this.ruleCount(model.ruleCount);
            this.unusedTypes(model.unusedTypes);
            this.unusedTypeValues(model.unusedTypeValues);
            this.unusedVariables(model.unusedVariables);
            this.conflictingRules(model.conflictingRules);
            this.disjointRuleSets(model.disjointRuleSets);
        }

        public final Integer getTypeCount() {
            return this.typeCount;
        }

        public final void setTypeCount(Integer typeCount) {
            this.typeCount = typeCount;
        }

        @Override
        public final Builder typeCount(Integer typeCount) {
            this.typeCount = typeCount;
            return this;
        }

        public final Integer getVariableCount() {
            return this.variableCount;
        }

        public final void setVariableCount(Integer variableCount) {
            this.variableCount = variableCount;
        }

        @Override
        public final Builder variableCount(Integer variableCount) {
            this.variableCount = variableCount;
            return this;
        }

        public final Integer getRuleCount() {
            return this.ruleCount;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        @Override
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public final Collection<String> getUnusedTypes() {
            if (this.unusedTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unusedTypes;
        }

        public final void setUnusedTypes(Collection<String> unusedTypes) {
            this.unusedTypes = AutomatedReasoningPolicyDefinitionTypeNameListCopier.copy(unusedTypes);
        }

        @Override
        public final Builder unusedTypes(Collection<String> unusedTypes) {
            this.unusedTypes = AutomatedReasoningPolicyDefinitionTypeNameListCopier.copy(unusedTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypes(String ... unusedTypes) {
            this.unusedTypes(Arrays.asList(unusedTypes));
            return this;
        }

        public final List<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> getUnusedTypeValues() {
            List<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> result = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier.copyToBuilder(this.unusedTypeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnusedTypeValues(Collection<AutomatedReasoningPolicyDefinitionTypeValuePair.BuilderImpl> unusedTypeValues) {
            this.unusedTypeValues = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier.copyFromBuilder(unusedTypeValues);
        }

        @Override
        public final Builder unusedTypeValues(Collection<AutomatedReasoningPolicyDefinitionTypeValuePair> unusedTypeValues) {
            this.unusedTypeValues = AutomatedReasoningPolicyDefinitionTypeValuePairListCopier.copy(unusedTypeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypeValues(AutomatedReasoningPolicyDefinitionTypeValuePair ... unusedTypeValues) {
            this.unusedTypeValues(Arrays.asList(unusedTypeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedTypeValues(Consumer<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> ... unusedTypeValues) {
            this.unusedTypeValues(Stream.of(unusedTypeValues).map(c -> (AutomatedReasoningPolicyDefinitionTypeValuePair)((AutomatedReasoningPolicyDefinitionTypeValuePair.Builder)AutomatedReasoningPolicyDefinitionTypeValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getUnusedVariables() {
            if (this.unusedVariables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unusedVariables;
        }

        public final void setUnusedVariables(Collection<String> unusedVariables) {
            this.unusedVariables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(unusedVariables);
        }

        @Override
        public final Builder unusedVariables(Collection<String> unusedVariables) {
            this.unusedVariables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(unusedVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unusedVariables(String ... unusedVariables) {
            this.unusedVariables(Arrays.asList(unusedVariables));
            return this;
        }

        public final Collection<String> getConflictingRules() {
            if (this.conflictingRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.conflictingRules;
        }

        public final void setConflictingRules(Collection<String> conflictingRules) {
            this.conflictingRules = AutomatedReasoningPolicyConflictedRuleIdListCopier.copy(conflictingRules);
        }

        @Override
        public final Builder conflictingRules(Collection<String> conflictingRules) {
            this.conflictingRules = AutomatedReasoningPolicyConflictedRuleIdListCopier.copy(conflictingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conflictingRules(String ... conflictingRules) {
            this.conflictingRules(Arrays.asList(conflictingRules));
            return this;
        }

        public final List<AutomatedReasoningPolicyDisjointRuleSet.Builder> getDisjointRuleSets() {
            List<AutomatedReasoningPolicyDisjointRuleSet.Builder> result = AutomatedReasoningPolicyDisjointRuleSetListCopier.copyToBuilder(this.disjointRuleSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet.BuilderImpl> disjointRuleSets) {
            this.disjointRuleSets = AutomatedReasoningPolicyDisjointRuleSetListCopier.copyFromBuilder(disjointRuleSets);
        }

        @Override
        public final Builder disjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet> disjointRuleSets) {
            this.disjointRuleSets = AutomatedReasoningPolicyDisjointRuleSetListCopier.copy(disjointRuleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disjointRuleSets(AutomatedReasoningPolicyDisjointRuleSet ... disjointRuleSets) {
            this.disjointRuleSets(Arrays.asList(disjointRuleSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disjointRuleSets(Consumer<AutomatedReasoningPolicyDisjointRuleSet.Builder> ... disjointRuleSets) {
            this.disjointRuleSets(Stream.of(disjointRuleSets).map(c -> (AutomatedReasoningPolicyDisjointRuleSet)((AutomatedReasoningPolicyDisjointRuleSet.Builder)AutomatedReasoningPolicyDisjointRuleSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedReasoningPolicyDefinitionQualityReport build() {
            return new AutomatedReasoningPolicyDefinitionQualityReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyDefinitionQualityReport> {
        public Builder typeCount(Integer var1);

        public Builder variableCount(Integer var1);

        public Builder ruleCount(Integer var1);

        public Builder unusedTypes(Collection<String> var1);

        public Builder unusedTypes(String ... var1);

        public Builder unusedTypeValues(Collection<AutomatedReasoningPolicyDefinitionTypeValuePair> var1);

        public Builder unusedTypeValues(AutomatedReasoningPolicyDefinitionTypeValuePair ... var1);

        public Builder unusedTypeValues(Consumer<AutomatedReasoningPolicyDefinitionTypeValuePair.Builder> ... var1);

        public Builder unusedVariables(Collection<String> var1);

        public Builder unusedVariables(String ... var1);

        public Builder conflictingRules(Collection<String> var1);

        public Builder conflictingRules(String ... var1);

        public Builder disjointRuleSets(Collection<AutomatedReasoningPolicyDisjointRuleSet> var1);

        public Builder disjointRuleSets(AutomatedReasoningPolicyDisjointRuleSet ... var1);

        public Builder disjointRuleSets(Consumer<AutomatedReasoningPolicyDisjointRuleSet.Builder> ... var1);
    }
}

