/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.SortingOrder;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class SortingParams
implements IParams {
    private final List<byte[]> params = new ArrayList<byte[]>();

    public SortingParams by(String pattern) {
        return this.by(SafeEncoder.encode(pattern));
    }

    public SortingParams by(byte[] pattern) {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(pattern);
        return this;
    }

    public SortingParams nosort() {
        this.params.add(Protocol.Keyword.BY.getRaw());
        this.params.add(Protocol.Keyword.NOSORT.getRaw());
        return this;
    }

    @Deprecated
    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public SortingParams desc() {
        return this.sortingOrder(SortingOrder.DESC);
    }

    public SortingParams asc() {
        return this.sortingOrder(SortingOrder.ASC);
    }

    public SortingParams sortingOrder(SortingOrder order) {
        this.params.add(order.getRaw());
        return this;
    }

    public SortingParams limit(int start, int count) {
        this.params.add(Protocol.Keyword.LIMIT.getRaw());
        this.params.add(Protocol.toByteArray(start));
        this.params.add(Protocol.toByteArray(count));
        return this;
    }

    public SortingParams alpha() {
        this.params.add(Protocol.Keyword.ALPHA.getRaw());
        return this;
    }

    public SortingParams get(String ... patterns) {
        for (String pattern : patterns) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(SafeEncoder.encode(pattern));
        }
        return this;
    }

    public SortingParams get(byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            this.params.add(Protocol.Keyword.GET.getRaw());
            this.params.add(pattern);
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        for (byte[] param : this.params) {
            args.add(param);
        }
    }
}

