/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.engine.sqlite;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.database.FFIndex;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.engine.sqlite.SQLiteConnectionProvider;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;

public class SQLiteTableManager {
    private static final Logger log = Logger.getLogger(SQLiteTableManager.class.getName());
    @NotNull
    private final FFProperties properties;
    @NotNull
    private final SQLiteConnectionProvider sqLiteConnectionProvider;

    public SQLiteTableManager(@NotNull FFProperties properties, @NotNull SQLiteConnectionProvider sqLiteConnectionProvider) {
        this.properties = properties;
        this.sqLiteConnectionProvider = sqLiteConnectionProvider;
    }

    public void init() throws SQLException {
        log.finer("Initializing the table manager");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement();){
            statement.execute("create table if not exists table_registry\n    (\n        name                    varchar primary key,\n        checksum                integer,\n        date                    timestamp\n    );\n");
            statement.execute("create table if not exists database_registry\n    (\n        name                    varchar primary key,\n        path                    varchar\n    );\n");
            ResultSet resultSet = statement.executeQuery("SELECT * FROM database_registry");
            while (resultSet.next()) {
                String schemaName = resultSet.getString("name");
                String path = resultSet.getString("path");
                statement.execute("ATTACH DATABASE '" + path + "' AS " + FFDriverUtils.quote(schemaName));
            }
            log.finer("Initialized the table manager");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    boolean isLoaded(@NotNull FFTable<?, ?> table) throws SQLException {
        String sql = "select name, checksum, date from table_registry where name = ?";
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement statement = this.sqLiteConnectionProvider.getConnection().prepareStatement(sql);){
            statement.setString(1, table.tableName().asString());
            statement.execute();
            ResultSet resultSet = statement.getResultSet();
            if (resultSet.next()) {
                boolean bl;
                block14: {
                    try {
                        if (resultSet.getLong("checksum") == table.checksum()) {
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                    catch (IOException e) {
                        block15: {
                            log.log(Level.SEVERE, "Failed to check if the table is loaded [table=" + table.tableName().asString() + "]", e);
                            if (statement == null) break block15;
                            statement.close();
                        }
                        return false;
                    }
                }
                return bl;
            }
            return false;
            {
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    synchronized void ensureLoaded(@NotNull Set<FFTableName> tables, @NotNull FFConnection connection, @NotNull AtomicBoolean canceled) throws SQLException {
        FFDatabase database = connection.getDatabase();
        ArrayList notLoadedTables = new ArrayList();
        for (FFTableName tableName : tables) {
            FFTable<?, ?> tabled = database.table(tableName);
            if (this.isLoaded(tabled)) continue;
            notLoadedTables.add(tabled);
        }
        if (!notLoadedTables.isEmpty()) {
            String tablesToLoad = notLoadedTables.stream().map(FFTable::tableName).map(FFTableName::asString).collect(Collectors.joining(", "));
            log.info("Loading tables into the internal database [tables=" + tablesToLoad + "]");
            for (FFTable fFTable : notLoadedTables) {
                this.loadTable(fFTable, connection, canceled);
                log.info("Table loaded successfully [table=" + fFTable.tableName().asString() + "]");
            }
        }
    }

    private void loadTable(@NotNull FFTable<?, ?> table, @NotNull FFConnection ffConnection, @NotNull AtomicBoolean canceled) throws SQLException {
        try {
            this.createDatabase(table.tableName().schema());
            this.createTable(table);
            this.loadData(table, ffConnection, canceled);
            this.createIndices(table, canceled);
            this.updateMetadata(table, canceled);
        }
        catch (Exception e) {
            throw FFExceptionUtils.wrapException(e);
        }
    }

    private void createDatabase(@NotNull FFSchemaName schema) throws SQLException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement();){
            ResultSet resultSet = statement.executeQuery("SELECT * FROM database_registry WHERE name = " + schema.asString());
            if (resultSet.next()) {
                return;
            }
            String databaseFileName = String.format("%d.db", Instant.now().toEpochMilli());
            Path databasePath = this.sqLiteConnectionProvider.getDatabaseDir().resolve(databaseFileName).toAbsolutePath();
            statement.execute("ATTACH DATABASE '" + String.valueOf(databasePath) + "' AS " + schema.asString());
            statement.execute("INSERT INTO database_registry(name, path) VALUES(%s, %s)".formatted(schema.asString(), FFDriverUtils.quote(databasePath.toString())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createTable(@NotNull FFTable<?, ?> tableMetadata) throws SQLException, IOException {
        FFTableName tableName = tableMetadata.tableName();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement();){
            statement.execute("DROP TABLE IF EXISTS " + tableName.asString());
            FFTableStructure<?, ?> structure = tableMetadata.structure();
            statement.execute(SQLiteTableManager.generateCreateTableSql(tableName, structure));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    private static String generateCreateTableSql(@NotNull FFTableName tableName, @NotNull FFTableStructure<?, ?> structure) {
        String columns = structure.columns().stream().map(column -> FFDriverUtils.quote(column.columnLabel()) + " " + column.typeName()).collect(Collectors.joining(", "));
        return "CREATE TABLE %s (\n    %s\n)\n".formatted(tableName.asString(), columns);
    }

    @NotNull
    private static String generateCreateIndexSql(@NotNull FFIndex index) {
        String columns = index.columnNames().stream().map(FFDriverUtils::quote).collect(Collectors.joining(", "));
        FFTableName tableName = index.tableName();
        return "CREATE INDEX %s ON %s (%s)\n".formatted(FFDriverUtils.quote(tableName.schema().name()) + "." + FFDriverUtils.quote(tableName.name() + "__" + index.indexName()), FFDriverUtils.quote(tableName.name()), columns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData(@NotNull FFTable<?, ?> table, @NotNull FFConnection ffConnection, @NotNull AtomicBoolean canceled) throws SQLException, IOException {
        FFTableName tableName = table.tableName();
        FFTableStructure<?, ?> tableStructure = table.structure();
        String columns = tableStructure.columns().stream().map(ColumnInfo::columnLabel).map(FFDriverUtils::quote).collect(Collectors.joining(", "));
        String values = tableStructure.columns().stream().map(column -> "?").collect(Collectors.joining(", "));
        String sql = "INSERT INTO %s (%s) VALUES (%s)\n".formatted(tableName.asString(), columns, values);
        Connection sqLiteConnection = this.sqLiteConnectionProvider.getConnection();
        Throwable throwable = null;
        Object var11_12 = null;
        try {
            PreparedStatement stmt = sqLiteConnection.prepareStatement(sql);
            try {
                try (Statement fileStatement = ffConnection.createStatement();){
                    int rowsCount = 0;
                    int batchesCount = 0;
                    ResultSet resultSet = fileStatement.executeQuery("select * from " + tableName.asString());
                    while (resultSet.next()) {
                        if (canceled.get()) {
                            throw new SQLException("The statement was canceled.");
                        }
                        int i = 0;
                        while (i < tableStructure.columns().size()) {
                            int columnDataType = tableStructure.columns().get(i).type();
                            stmt.setObject(i + 1, this.extractColumnValue(columnDataType, resultSet, i + 1));
                            ++i;
                        }
                        stmt.addBatch();
                        if (++rowsCount % this.properties.internalDatabaseBatchSize() == 0) {
                            stmt.executeBatch();
                            ++batchesCount;
                        }
                        if (batchesCount % this.properties.internalDatabaseTransactionSize() != 0) continue;
                        sqLiteConnection.commit();
                    }
                    stmt.executeBatch();
                    sqLiteConnection.commit();
                }
                if (stmt == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void createIndices(@NotNull FFTable<?, ?> table, @NotNull AtomicBoolean canceled) throws SQLException, IOException {
        if (canceled.get()) {
            throw new SQLException("The statement was canceled.");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement statement = this.sqLiteConnectionProvider.getConnection().createStatement();){
            for (FFIndex index : table.structure().indices()) {
                statement.execute(SQLiteTableManager.generateCreateIndexSql(index));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updateMetadata(@NotNull FFTable<?, ?> table, @NotNull AtomicBoolean canceled) throws SQLException, IOException {
        if (canceled.get()) {
            throw new SQLException("The statement was canceled.");
        }
        String sql = "insert or replace into table_registry(name, checksum, date) values(?, ?, ?)";
        Connection sqLiteConnection = this.sqLiteConnectionProvider.getConnection();
        Throwable throwable = null;
        Object var6_7 = null;
        try (PreparedStatement stmt = sqLiteConnection.prepareStatement(sql);){
            stmt.setString(1, table.tableName().asString());
            stmt.setLong(2, table.checksum());
            stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            stmt.execute();
            sqLiteConnection.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Object extractColumnValue(int type, ResultSet resultSet, int columnIndex) throws SQLException {
        try {
            Object value = FFDriverUtils.extractColumnValueByType(type, resultSet, columnIndex);
            if (value instanceof Date) {
                return this.stringifyDate((Date)value, type);
            }
            return value;
        }
        catch (Exception exception) {
            return resultSet.getObject(columnIndex);
        }
    }

    private String stringifyDate(@NotNull Date date, int type) {
        return switch (JDBCType.valueOf(type)) {
            case JDBCType.TIMESTAMP -> FFDriverUtils.TIMESTAMP_FORMAT_LONG.format(date);
            case JDBCType.DATE -> FFDriverUtils.DATE_FORMAT.format(date);
            case JDBCType.TIME -> FFDriverUtils.TIME_FORMAT_SHORT.format(date);
            default -> date.toString();
        };
    }
}

