/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.database.FFChecksumable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.zip.CRC32;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public record FFTableSource(@NotNull FFDataSource<?> dataSource, @NotNull List<Path> dataFiles, @NotNull String sourceName, @Nullable Path metadataFile) implements FFChecksumable<Exception>
{
    @Override
    public long checksum() throws IOException {
        CRC32 crc32 = new CRC32();
        for (Path dataFile : this.dataFiles) {
            crc32.update(Files.getLastModifiedTime(dataFile, new LinkOption[0]).toString().getBytes());
        }
        if (this.metadataFile != null) {
            crc32.update(Files.getLastModifiedTime(this.metadataFile, new LinkOption[0]).toString().getBytes());
        }
        return crc32.getValue();
    }

    public String remarks() {
        long totalSize = this.dataFiles.stream().mapToLong(path -> {
            try {
                return Files.size(path);
            }
            catch (IOException iOException) {
                return 0L;
            }
        }).sum();
        return "dataFiles=" + this.dataFiles + ";" + "sourceName=" + this.sourceName + ";" + "totalSize=" + FFTableSource.humanReadableByteCountSI(totalSize) + ";" + "metadataFile=" + this.metadataFile + ";";
    }

    private static String humanReadableByteCountSI(long bytes) {
        if (-1000L < bytes && bytes < 1000L) {
            return bytes + " B";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950L || bytes >= 999950L) {
            bytes /= 1000L;
            ci.next();
        }
        return String.format("%.1f %cB", (double)bytes / 1000.0, Character.valueOf(ci.current()));
    }
}

