/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.base.ValueReader;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.api.FFJdbcResultSetMetaData;
import com.dbeaver.jdbc.files.api.FFStatement;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.model.AbstractJdbcResultSet;
import com.dbeaver.jdbc.model.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class FFResultSet
extends AbstractJdbcResultSet<FFStatement, FFJdbcResultSetMetaData> {
    @NotNull
    private final FFTableReader<?> tableReader;
    @Nullable
    private Object[] currentRow;
    @Nullable
    private Object lastReadValue;
    private final long maxRows;
    private long currentRowNumber = 0L;
    private volatile boolean closed = false;

    public FFResultSet(@NotNull FFStatement statement, @NotNull FFJdbcResultSetMetaData metadata, @NotNull FFTableReader<?> tableReader, long maxRows) {
        super((AbstractJdbcStatement)statement, (AbstractJdbcResultSetMetaData)metadata);
        this.tableReader = tableReader;
        this.maxRows = maxRows;
    }

    @Nullable
    public Object getObject(int columnIndex) throws SQLException {
        this.ensureOpen();
        if (this.currentRow == null) {
            throw new SQLException("No current row");
        }
        if (columnIndex < 1 || columnIndex > ((FFJdbcResultSetMetaData)this.metadata).columns().length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        if (columnIndex > this.currentRow.length) {
            return null;
        }
        try {
            int type = ((FFJdbcResultSetMetaData)this.metadata).columns()[columnIndex - 1].type();
            return FFDriverUtils.extractColumnValueByType(type, (ResultSet)((Object)this), columnIndex);
        }
        catch (Exception exception) {
            return this.getRowValue(columnIndex);
        }
    }

    public boolean last() throws SQLException {
        while (this.next()) {
        }
        return true;
    }

    public int getRow() throws SQLException {
        return (int)this.currentRowNumber;
    }

    /*
     * Unable to fully structure code
     */
    public boolean absolute(int row) throws SQLException {
        if (row >= 0) ** GOTO lbl5
        throw new SQLException("Row number must be positive");
lbl-1000:
        // 1 sources

        {
            if (this.next()) continue;
            return false;
lbl5:
            // 2 sources

            ** while (this.currentRowNumber < (long)row)
        }
lbl6:
        // 1 sources

        return true;
    }

    public boolean relative(int rows) throws SQLException {
        if (rows == 0) {
            return true;
        }
        if (rows < 0) {
            throw new SQLException("Negative rows are not supported");
        }
        int i = 0;
        while (i < rows) {
            if (!this.next()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public int findColumn(String columnLabel) throws SQLException {
        this.ensureOpen();
        ColumnInfo<?>[] columns = ((FFJdbcResultSetMetaData)this.metadata).columns();
        int i = 0;
        while (i < columns.length) {
            if (columnLabel.equals(columns[i].columnLabel())) {
                return i + 1;
            }
            ++i;
        }
        throw new SQLException("Column '" + columnLabel + "' not found in result set");
    }

    @Nullable
    public String getString(int columnIndex) throws SQLException {
        this.ensureOpen();
        return CommonUtils.toString((Object)this.getRowValue(columnIndex), null);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.ensureOpen();
        return FFResultSet.parseBoolean(this.getRowValue(columnIndex));
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.ensureOpen();
        return (byte)CommonUtils.toInt((Object)this.getRowValue(columnIndex));
    }

    public short getShort(int columnIndex) throws SQLException {
        this.ensureOpen();
        Object object = this.getRowValue(columnIndex);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.shortValue();
        }
        return (short)Integer.parseInt(CommonUtils.toString((Object)object));
    }

    public int getInt(int columnIndex) throws SQLException {
        this.ensureOpen();
        Object object = this.getRowValue(columnIndex);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.intValue();
        }
        return Integer.parseInt(CommonUtils.toString((Object)object));
    }

    public long getLong(int columnIndex) throws SQLException {
        this.ensureOpen();
        Object object = this.getRowValue(columnIndex);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.longValue();
        }
        return Long.parseLong(CommonUtils.toString((Object)object));
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.ensureOpen();
        Object object = this.getRowValue(columnIndex);
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.floatValue();
        }
        return Float.parseFloat(CommonUtils.toString((Object)object));
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.ensureOpen();
        Object object = this.getRowValue(columnIndex);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue();
        }
        return Double.parseDouble(CommonUtils.toString((Object)object));
    }

    @Nullable
    public Date getDate(int columnIndex, @Nullable Calendar cal) throws SQLException {
        Object object;
        block5: {
            this.ensureOpen();
            object = this.getRowValue(columnIndex);
            try {
                if (object != null) break block5;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to date", e);
            }
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof java.util.Date) {
            return new Date(((java.util.Date)object).getTime());
        }
        return Date.valueOf(object.toString());
    }

    @Nullable
    public Time getTime(int columnIndex, @Nullable Calendar cal) throws SQLException {
        java.util.Date timeValue;
        Object object;
        block9: {
            this.ensureOpen();
            object = this.getRowValue(columnIndex);
            try {
                if (object != null) break block9;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to time", e);
            }
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof java.util.Date) {
            return new Time(((java.util.Date)object).getTime());
        }
        try {
            timeValue = FFDriverUtils.TIME_FORMAT_LONG.parse(object.toString());
        }
        catch (ParseException parseException) {
            try {
                timeValue = FFDriverUtils.TIME_FORMAT_SHORT.parse(object.toString());
            }
            catch (ParseException parseException2) {
                timeValue = Time.valueOf(object.toString());
            }
        }
        return new Time(timeValue.getTime());
    }

    @Nullable
    public Timestamp getTimestamp(int columnIndex, @Nullable Calendar cal) throws SQLException {
        java.util.Date timeValue;
        Object object;
        block9: {
            this.ensureOpen();
            object = this.getRowValue(columnIndex);
            try {
                if (object != null) break block9;
                return null;
            }
            catch (Exception e) {
                throw new SQLException("Error converting from object '" + String.valueOf(object) + "' to timestamp", e);
            }
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)object).getTime());
        }
        try {
            timeValue = FFDriverUtils.TIMESTAMP_FORMAT_LONG.parse(object.toString());
        }
        catch (ParseException parseException) {
            try {
                timeValue = FFDriverUtils.TIMESTAMP_FORMAT_SHORT.parse(object.toString());
            }
            catch (ParseException parseException2) {
                timeValue = Timestamp.valueOf(object.toString());
            }
        }
        return new Timestamp(timeValue.getTime());
    }

    public boolean next() throws SQLException {
        this.ensureOpen();
        if (this.maxRows > 0L && this.currentRowNumber >= this.maxRows) {
            return false;
        }
        try {
            boolean next;
            this.currentRow = this.tableReader.readRow();
            boolean bl = next = this.currentRow != null;
            if (next) {
                ++this.currentRowNumber;
            }
            return next;
        }
        catch (IOException e) {
            throw new SQLException("Failed to read next row", e);
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        try {
            this.tableReader.close();
        }
        catch (IOException e) {
            throw new SQLException("Failed to close table reader", e);
        }
    }

    public boolean isClosed() throws SQLException {
        return ((FFStatement)this.statement).isClosed() || this.closed;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLException("Only FETCH_FORWARD is supported");
        }
    }

    public boolean wasNull() throws SQLException {
        this.ensureOpen();
        return this.lastReadValue == null;
    }

    private Object getRowValue(int columnIndex) throws SQLException {
        Object value;
        this.ensureOpen();
        if (this.currentRow == null) {
            throw new SQLException("No current row");
        }
        if (columnIndex < 1 || columnIndex > ((FFJdbcResultSetMetaData)this.metadata).columns().length) {
            throw new SQLException("Invalid column index: " + columnIndex);
        }
        if (columnIndex > this.currentRow.length) {
            return null;
        }
        ValueReader reader = ((FFJdbcResultSetMetaData)this.metadata).columns()[columnIndex - 1].reader();
        this.lastReadValue = value = reader.extractValue(this.currentRow[columnIndex - 1]);
        return value;
    }

    private void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set is closed");
        }
    }

    private static boolean parseBoolean(Object value) {
        block19: {
            String s;
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return b;
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                if (n.intValue() == 0) {
                    return false;
                }
                if (n.intValue() == 1) {
                    return true;
                }
                throw new IllegalArgumentException("Invalid boolean value: " + String.valueOf(value));
            }
            if (!(value instanceof String)) break block19;
            return switch (s = (String)value) {
                case "1", "true" -> true;
                case "0", "false" -> false;
                default -> throw new IllegalArgumentException("Invalid boolean value: " + String.valueOf(value));
            };
        }
        throw new IllegalArgumentException("Invalid boolean value: " + String.valueOf(value));
    }
}

