/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.api.FFStatement;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.model.AbstractJdbcResultSetMetaData;
import com.dbeaver.jdbc.model.AbstractJdbcStatement;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FFJdbcResultSetMetaData
extends AbstractJdbcResultSetMetaData<FFStatement> {
    public static final int DEFAULT_COLUMN_SIZE = 20;
    @NotNull
    private final FFTableName tableName;
    @NotNull
    private final ColumnInfo<?>[] columns;

    public FFJdbcResultSetMetaData(@NotNull FFStatement statement, @NotNull FFTableName tableName, @NotNull ColumnInfo<?>[] columns) {
        super((AbstractJdbcStatement)statement);
        this.tableName = tableName;
        this.columns = columns;
    }

    public ColumnInfo<?>[] columns() {
        return this.columns;
    }

    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return 2;
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return 20;
    }

    @Nullable
    public String getColumnLabel(int column) throws SQLException {
        return this.columns[column - 1].columnLabel();
    }

    @Nullable
    public String getColumnName(int column) throws SQLException {
        return this.columns[column - 1].columnLabel();
    }

    @Nullable
    public String getSchemaName(int column) throws SQLException {
        return this.tableName.schema().name();
    }

    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Nullable
    public String getTableName(int column) throws SQLException {
        return this.tableName.name();
    }

    @Nullable
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    public int getColumnType(int column) throws SQLException {
        return this.columns[column - 1].type();
    }

    @Nullable
    public String getColumnTypeName(int column) throws SQLException {
        return this.columns[column - 1].typeName();
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }
}

