/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import java.util.Set;
import org.jkiss.code.Nullable;

public enum FFDataSourceFormat {
    CSV(Set.of("csv", "tcv", "txt")),
    EXCEL(Set.of("xlsx", "xls")),
    PARQUET(Set.of("parquet")),
    JSON(Set.of("json")),
    XML(Set.of("xml"));

    private final Set<String> fileExtensions;

    private FFDataSourceFormat(Set<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    public Set<String> fileExtensions() {
        return this.fileExtensions;
    }

    @Nullable
    public static FFDataSourceFormat parse(@Nullable String value) {
        if (value == null || value.isBlank()) {
            return null;
        }
        return FFDataSourceFormat.valueOf(value.toUpperCase());
    }
}

