/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableName;
import java.nio.file.Path;
import java.util.List;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;

public class GenericTableNameFactory
implements FFTableNameFactory {
    @NotNull
    private final FFDataSource<? extends FFProperties> dataSource;

    public GenericTableNameFactory(@NotNull FFDataSource<? extends FFProperties> dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    @NotNull
    public List<FFTableName> createTableNames(@NotNull Path file, @NotNull List<String> tableSourceNames) {
        Path root = this.dataSource.path();
        FFProperties properties = this.dataSource.properties();
        Path relativized = root.relativize(file);
        if (relativized.getNameCount() <= 1) {
            FFSchemaName schemaName = new FFSchemaName(properties.defaultSchema());
            return tableSourceNames.stream().map(it -> new FFTableName(schemaName, (String)it)).toList();
        }
        StringJoiner stringJoiner = new StringJoiner(properties.subfolderNameSeparator());
        Path folder = relativized.getParent();
        if (folder != null) {
            folder.forEach(path -> {
                Path name = path.getFileName();
                if (name != null) {
                    stringJoiner.add(name.toString());
                }
            });
        }
        FFSchemaName schemaName = new FFSchemaName(stringJoiner.toString());
        return tableSourceNames.stream().map(it -> new FFTableName(schemaName, (String)it)).toList();
    }
}

