/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFTablePropertiesParser;
import com.dbeaver.jdbc.files.database.FFColumnConstraint;
import com.dbeaver.jdbc.files.database.FFIndex;
import com.dbeaver.jdbc.files.database.FFPrimaryKey;
import com.dbeaver.jdbc.files.database.FFSQLType;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTableDefinition;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class FFExternalMetadataReaderImpl<P extends FFTableProperties>
implements FFExternalMetadataReader<P> {
    private static final String PRIMARY_KEY_CONSTRAINT_NAME_FORMAT = "PK_%s";
    private static final String UNIQUE_INDEX_NAME_FORMAT = "UNIQUE_%s_%s_idx";
    private static final String INDEX_NAME_FORMAT = "INDEX_%s_%s_idx";
    private static final Logger log = Logger.getLogger(FFExternalMetadataReaderImpl.class.getName());
    @NotNull
    private final FFTablePropertiesParser<P> tablePropertiesParser;

    public FFExternalMetadataReaderImpl(@NotNull FFTablePropertiesParser<P> tablePropertiesParser) {
        this.tablePropertiesParser = tablePropertiesParser;
    }

    @Override
    @NotNull
    public <T> List<FFTableDefinition<T, P>> readTableDefinitions(@NotNull FFSchemaName schemaName, @NotNull Path metadataFile) throws IOException, SQLException {
        return this.readTableDefinitionsFromScript(schemaName, Files.readString(metadataFile));
    }

    @Override
    @NotNull
    public <T> List<FFTableDefinition<T, P>> readTableDefinitionsFromScript(@NotNull FFSchemaName schemaName, @NotNull String script) throws SQLException {
        try {
            Statements statements = CCJSqlParserUtil.parseStatements((String)script);
            Map<String, List<Statement>> tableStatementsMap = this.groupStatementsByTable(statements.getStatements());
            ArrayList<FFTableDefinition<T, P>> definitions = new ArrayList<FFTableDefinition<T, P>>();
            for (Map.Entry<String, List<Statement>> entry : tableStatementsMap.entrySet()) {
                String tableName = FFDriverUtils.unquote(entry.getKey());
                List<Statement> tableStatements = entry.getValue();
                try {
                    FFTableStructure<T, P> tableStructure = this.parseTableStructure(schemaName, tableStatements);
                    definitions.add(new FFTableDefinition<T, P>(new FFTableName(schemaName, tableName), tableStructure));
                }
                catch (SQLException e) {
                    throw new SQLException("Failed to parse table: " + tableName, e);
                }
            }
            return definitions;
        }
        catch (JSQLParserException e) {
            throw new SQLException("Failed to parse SQL script: " + e.getMessage(), e);
        }
    }

    private Map<String, List<Statement>> groupStatementsByTable(List<Statement> statements) throws SQLException {
        LinkedHashMap<String, List<Statement>> tableToStatements = new LinkedHashMap<String, List<Statement>>();
        for (Statement stmt : statements) {
            String tableName = this.extractTableName(stmt);
            tableToStatements.computeIfAbsent(tableName, k -> new ArrayList()).add(stmt);
        }
        return tableToStatements;
    }

    private String extractTableName(Statement statement) throws SQLException {
        if (statement instanceof CreateTable) {
            CreateTable createTable = (CreateTable)statement;
            return createTable.getTable().getName();
        }
        if (statement instanceof CreateIndex) {
            CreateIndex createIndex = (CreateIndex)statement;
            return createIndex.getTable().getName();
        }
        throw new SQLException("Unsupported statement type: " + statement.toString());
    }

    private <T> FFTableStructure<T, P> parseTableStructure(@NotNull FFSchemaName schemaName, @NotNull List<Statement> statements) throws SQLException {
        CreateTable createTable = this.extractCreateTableStatement(statements);
        Table table = createTable.getTable();
        this.validateTableSchemaAndDatabase(table);
        FFTableName tableName = new FFTableName(schemaName, FFDriverUtils.unquote(table.getName()));
        List columnDefinitions = createTable.getColumnDefinitions();
        HashSet<String> tableColumns = new HashSet<String>();
        ArrayList columnInfos = new ArrayList();
        ArrayList<FFIndex> indexes = new ArrayList<FFIndex>();
        AtomicReference<Object> primaryKeyRef = new AtomicReference<Object>(null);
        for (ColumnDefinition columnDef : columnDefinitions) {
            String columnName = FFDriverUtils.unquote(columnDef.getColumnName().toLowerCase());
            this.validateUniqueColumnName(tableName, columnName, tableColumns);
            Set<FFColumnConstraint> constraints = this.parseColumnConstraints(columnDef);
            this.handleColumnConstraints(tableName, columnName, constraints, indexes, primaryKeyRef);
            ColumnInfo<T> columnInfo = this.createColumnInfo(tableName, columnDef);
            columnInfos.add(columnInfo);
        }
        List tableIndexes = Optional.ofNullable(createTable.getIndexes()).orElse(Collections.emptyList());
        for (Index index : tableIndexes) {
            indexes.add(this.handleTableIndex(index, tableName, tableColumns, primaryKeyRef));
        }
        int i = 1;
        while (i < statements.size()) {
            CreateIndex createIndex;
            Statement stmt = statements.get(i);
            if (stmt instanceof CreateIndex) {
                createIndex = (CreateIndex)stmt;
                if (!createIndex.getTailParameters().isEmpty()) {
                    throw new SQLException("Unexpected index parameters: " + String.valueOf(createIndex.getTailParameters()));
                }
            } else {
                throw new SQLException("Unexpected statement type: " + stmt.getClass().getSimpleName());
            }
            indexes.add(this.handleTableIndex(createIndex.getIndex(), tableName, tableColumns, primaryKeyRef));
            ++i;
        }
        FFExternalMetadataReaderImpl.validateIndexes(indexes);
        Map<String, String> tableOptions = this.parseTableOptions(createTable);
        P tableProperties = this.tablePropertiesParser.parseTableProperties(tableOptions);
        String formattedStatements = FFDriverUtils.formatStatements(statements);
        return new FFTableStructure(primaryKeyRef.get(), columnInfos, indexes, tableProperties, formattedStatements);
    }

    /*
     * WARNING - void declaration
     */
    private CreateTable extractCreateTableStatement(List<Statement> statements) throws SQLException {
        void createTable;
        Statement statement;
        if (statements.isEmpty() || !((statement = statements.get(0)) instanceof CreateTable)) {
            throw new SQLException("The first statement must be a CREATE TABLE statement.");
        }
        CreateTable createTable2 = (CreateTable)statement;
        return createTable;
    }

    private void validateTableSchemaAndDatabase(Table table) throws SQLException {
        if (table.getSchemaName() != null && !table.getSchemaName().isEmpty()) {
            throw new SQLException("Schema name is not supported: " + table.getSchemaName());
        }
        if (table.getDatabase() != null && table.getDatabase().getDatabaseName() != null && !table.getDatabase().getDatabaseName().isBlank()) {
            throw new SQLException("Database name is not supported: " + String.valueOf(table.getDatabase()));
        }
    }

    private void validateUniqueColumnName(FFTableName tableName, String columnName, Set<String> existingSet) throws SQLException {
        if (!existingSet.add(columnName)) {
            throw new SQLException("Duplicate column name: " + columnName + " in table: " + tableName.asString());
        }
    }

    private Set<FFColumnConstraint> parseColumnConstraints(ColumnDefinition columnDef) {
        if (columnDef.getColumnSpecs() == null || columnDef.getColumnSpecs().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<FFColumnConstraint> constraints = new HashSet<FFColumnConstraint>();
        StringBuilder constraintBuilder = new StringBuilder();
        for (String spec : columnDef.getColumnSpecs()) {
            if (!constraintBuilder.isEmpty()) {
                constraintBuilder.append(" ");
            }
            constraintBuilder.append(spec);
            FFColumnConstraint constraint = FFColumnConstraint.fromKeyword(constraintBuilder.toString());
            if (constraint == null) continue;
            if (!constraints.add(constraint)) {
                throw new IllegalArgumentException("Duplicate constraint: " + String.valueOf(constraintBuilder));
            }
            constraintBuilder.setLength(0);
        }
        return constraints;
    }

    private void handleColumnConstraints(FFTableName tableName, String columnName, Set<FFColumnConstraint> constraints, List<FFIndex> indexes, AtomicReference<FFPrimaryKey> primaryKeyRef) throws SQLException {
        if (constraints.contains((Object)FFColumnConstraint.PRIMARY_KEY)) {
            indexes.add(this.handlePrimaryConstraint(null, tableName, List.of(columnName), primaryKeyRef));
        } else if (constraints.contains((Object)FFColumnConstraint.UNIQUE)) {
            indexes.add(this.createUniqueIndex(tableName, null, List.of(columnName)));
        }
    }

    private <T> ColumnInfo<T> createColumnInfo(FFTableName tableName, ColumnDefinition columnDef) throws SQLException {
        SQLType dataType;
        String columnName = FFDriverUtils.unquote(columnDef.getColumnName().toLowerCase());
        String dataTypeName = columnDef.getColDataType().getDataType();
        String fullTypeName = null;
        int columnPrecision = -1;
        int specDivPos = dataTypeName.indexOf("(");
        if (specDivPos != -1) {
            int lastPos = dataTypeName.indexOf(")", specDivPos);
            if (lastPos == -1) {
                lastPos = dataTypeName.length();
            }
            fullTypeName = dataTypeName;
            String spec = dataTypeName.substring(specDivPos + 1, lastPos);
            columnPrecision = CommonUtils.toInt((Object)spec);
            dataTypeName = dataTypeName.substring(0, specDivPos).trim();
        }
        if ((dataType = FFSQLType.parse(dataTypeName)) == null) {
            log.warning("Unsupported data type: " + dataTypeName + ". Fallback to varchar");
            dataType = FFSQLType.VARCHAR;
        }
        ColumnInfo columnInfo = new ColumnInfo(tableName.schema().name(), tableName.name(), columnName, columnName, dataType);
        if (fullTypeName != null) {
            columnInfo.setTypeName(fullTypeName);
        }
        columnInfo.setPrecision(columnPrecision);
        return columnInfo;
    }

    private FFIndex handleTableIndex(Index index, FFTableName tableName, Set<String> tableColumns, AtomicReference<FFPrimaryKey> primaryKeyRef) throws SQLException {
        String indexName = index.getName() != null ? FFDriverUtils.unquote(index.getName()) : null;
        List<String> indexedColumns = this.extractColumnNames(index);
        if (new HashSet<String>(indexedColumns).size() != indexedColumns.size()) {
            throw new SQLException("Duplicate column names in index: " + indexName);
        }
        for (String columnName : indexedColumns) {
            if (tableColumns.contains(columnName)) continue;
            throw new SQLException("Column not found: " + columnName + " for index: " + String.valueOf(indexName != null ? indexName : index));
        }
        String indexType = index.getType() != null ? index.getType().toUpperCase() : "";
        return switch (indexType) {
            case "PRIMARY KEY" -> this.handlePrimaryConstraint(indexName, tableName, indexedColumns, primaryKeyRef);
            case "UNIQUE" -> this.createUniqueIndex(tableName, indexName, indexedColumns);
            default -> this.createIndex(tableName, indexName, indexedColumns);
        };
    }

    private FFIndex handlePrimaryConstraint(@Nullable String constraintName, @NotNull FFTableName tableName, @NotNull List<String> indexedColumns, @NotNull AtomicReference<FFPrimaryKey> primaryKeyRef) throws SQLException {
        if (primaryKeyRef.get() != null) {
            throw new SQLException("Multiple primary keys found in table: " + tableName.asString());
        }
        String keyName = CommonUtils.isEmpty((String)constraintName) ? String.format(PRIMARY_KEY_CONSTRAINT_NAME_FORMAT, tableName.name()) : constraintName;
        FFPrimaryKey primaryKey = new FFPrimaryKey(tableName, keyName, indexedColumns);
        String indexName = keyName + "_idx";
        primaryKeyRef.set(primaryKey);
        return new FFIndex(tableName, indexName, indexedColumns, null, true);
    }

    private FFIndex createUniqueIndex(@NotNull FFTableName tableName, @Nullable String indexName, @NotNull List<String> indexedColumns) {
        String uniqueIndexName = Objects.requireNonNullElseGet(indexName, () -> String.format(UNIQUE_INDEX_NAME_FORMAT, tableName.name(), String.join((CharSequence)"_", indexedColumns)));
        return new FFIndex(tableName, uniqueIndexName, indexedColumns, null, true);
    }

    private FFIndex createIndex(@NotNull FFTableName tableName, @Nullable String indexName, @NotNull List<String> indexedColumns) {
        String uniqueIndexName = Objects.requireNonNullElseGet(indexName, () -> String.format(INDEX_NAME_FORMAT, tableName.name(), String.join((CharSequence)"_", indexedColumns)));
        return new FFIndex(tableName, uniqueIndexName, indexedColumns, null, false);
    }

    private List<String> extractColumnNames(Index index) {
        return index.getColumns().stream().map(Index.ColumnParams::getColumnName).map(String::toLowerCase).map(FFDriverUtils::unquote).collect(Collectors.toList());
    }

    private Map<String, String> parseTableOptions(CreateTable createTable) throws SQLException {
        List tableOptionsStrings = createTable.getTableOptionsStrings();
        if (tableOptionsStrings == null) {
            return Map.of();
        }
        if (tableOptionsStrings.size() % 2 != 0) {
            throw new SQLException("Invalid table options: " + String.valueOf(tableOptionsStrings));
        }
        HashMap<String, String> tableOptions = new HashMap<String, String>();
        int i = 0;
        while (i < tableOptionsStrings.size()) {
            tableOptions.put(((String)tableOptionsStrings.get(i)).toLowerCase(), (String)tableOptionsStrings.get(i + 1));
            i += 2;
        }
        return tableOptions;
    }

    private static void validateIndexes(List<FFIndex> indexes) throws SQLException {
        HashSet<String> indexNames = new HashSet<String>();
        for (FFIndex index : indexes) {
            if (indexNames.add(index.indexName())) continue;
            throw new SQLException("Duplicate index name: " + index.indexName());
        }
    }
}

