/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.impl.ResponseHandler;
import io.confluent.ksql.api.client.util.RowUtil;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.util.BytesUtils;
import io.vertx.core.Context;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class QueryResponseHandler<T extends CompletableFuture<?>>
extends ResponseHandler<T> {
    protected boolean hasReadArguments;

    QueryResponseHandler(Context context, RecordParser recordParser, T cf) {
        super(context, recordParser, cf);
    }

    @Override
    protected void doHandleBodyBuffer(Buffer buff) {
        Buffer strippedValidJson = BytesUtils.toJsonMsg((Buffer)buff, (boolean)true);
        if (!this.hasReadArguments) {
            this.handleArgs(strippedValidJson);
        } else if (!Objects.equals(strippedValidJson.toString(), "")) {
            this.handleRow(strippedValidJson);
        }
    }

    @Override
    protected void doHandleException(Throwable t) {
        if (!this.cf.isDone()) {
            this.cf.completeExceptionally(t);
        } else {
            this.handleExceptionAfterFutureCompleted(t);
        }
    }

    protected abstract void handleMetadata(QueryResponseMetadata var1);

    protected abstract void handleRow(Buffer var1);

    protected abstract void handleExceptionAfterFutureCompleted(Throwable var1);

    private void handleArgs(Buffer buff) {
        QueryResponseMetadata queryResponseMetadata;
        this.hasReadArguments = true;
        try {
            Object header = buff.toJsonObject().getMap().get("header");
            String queryId = (String)((Map)header).get("queryId");
            String schema = (String)((Map)header).get("schema");
            queryResponseMetadata = new QueryResponseMetadata(queryId, RowUtil.colNamesFromSchema(schema), RowUtil.colTypesFromSchema(schema), null);
        }
        catch (Exception e) {
            this.cf.completeExceptionally(e);
            return;
        }
        this.handleMetadata(queryResponseMetadata);
    }
}

